/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections;

import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import step.core.collections.Filter;

public class Filters {
    public static And and(List<Filter> filters) {
        return new And(filters);
    }

    public static Or or(List<Filter> filters) {
        return new Or(filters);
    }

    public static Not not(Filter filter) {
        return new Not(filter);
    }

    public static True empty() {
        return new True();
    }

    public static False falseFilter() {
        return new False();
    }

    public static Equals equals(String field, boolean expectedValue) {
        return new Equals(field, expectedValue);
    }

    public static Equals equals(String field, long expectedValue) {
        return new Equals(field, expectedValue);
    }

    public static Equals equals(String field, String expectedValue) {
        return new Equals(field, expectedValue);
    }

    public static Equals equals(String field, ObjectId expectedValue) {
        return new Equals(field, expectedValue);
    }

    public static Equals id(ObjectId id) {
        return Filters.equals("id", id);
    }

    public static Equals id(String id) {
        return Filters.id(new ObjectId(id));
    }

    public static Lt lt(String field, long value) {
        return new Lt(field, value);
    }

    public static Lte lte(String field, long value) {
        return new Lte(field, value);
    }

    public static Gt gt(String field, long value) {
        return new Gt(field, value);
    }

    public static Gte gte(String field, long value) {
        return new Gte(field, value);
    }

    public static Filter in(String field, List<String> values) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (String v : values) {
            filters.add(Filters.equals(field, v));
        }
        return filters.isEmpty() ? Filters.falseFilter() : Filters.or(filters);
    }

    public static Regex regex(String field, String expression, boolean caseSensitive) {
        return new Regex(field, expression, caseSensitive);
    }

    public static Fulltext fulltext(String expression) {
        return new Fulltext(expression);
    }

    public static class False
    extends AbstractAtomicFilter {
    }

    public static class True
    extends AbstractAtomicFilter {
    }

    public static class Regex
    extends AbstractAtomicFilter {
        private String field;
        private String expression;
        private boolean caseSensitive;

        public Regex() {
        }

        public Regex(String field, String expression, boolean caseSensitive) {
            this.field = field;
            this.expression = expression;
            this.caseSensitive = caseSensitive;
        }

        public String getField() {
            return this.field;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }
    }

    public static class In
    extends AbstractAtomicFilter {
        private String field;
        private List<String> values;

        public In() {
        }

        public In(String field, List<String> values) {
            this.field = field;
            this.values = values;
        }

        public String getField() {
            return this.field;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }

    public static class Lte
    extends AbstractAtomicFilter {
        private String field;
        private long value;

        public Lte() {
        }

        public Lte(String field, long value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public long getValue() {
            return this.value;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    public static class Lt
    extends AbstractAtomicFilter {
        private String field;
        private long value;

        public Lt() {
        }

        public Lt(String field, long value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public long getValue() {
            return this.value;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    public static class Gte
    extends AbstractAtomicFilter {
        private String field;
        private long value;

        public Gte() {
        }

        public Gte(String field, long value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public long getValue() {
            return this.value;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    public static class Gt
    extends AbstractAtomicFilter {
        private String field;
        private long value;

        public Gt() {
        }

        public Gt(String field, long value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public long getValue() {
            return this.value;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    public static class Equals
    extends AbstractAtomicFilter {
        private String field;
        private Object expectedValue;

        public Equals() {
        }

        public Equals(String field, Object expectedValue) {
            this.field = field;
            this.expectedValue = expectedValue;
        }

        public String getField() {
            return this.field;
        }

        public Object getExpectedValue() {
            return this.expectedValue;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setExpectedValue(Object expectedValue) {
            this.expectedValue = expectedValue;
        }
    }

    public static class Fulltext
    extends AbstractAtomicFilter {
        private String expression;

        public Fulltext() {
        }

        public Fulltext(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }

    public static class Not
    extends AbstractCompositeFilter {
        private Filter filter;

        public Not() {
        }

        public Not(Filter filter) {
            super(new ArrayList<Filter>(List.of(filter)));
            this.filter = filter;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }
    }

    public static class Or
    extends AbstractCompositeFilter {
        public Or() {
        }

        public Or(List<Filter> filters) {
            super(filters);
        }
    }

    public static class And
    extends AbstractCompositeFilter {
        public And() {
        }

        public And(List<Filter> filters) {
            super(filters);
        }
    }

    public static class AbstractAtomicFilter
    implements Filter {
        @Override
        public List<Filter> getChildren() {
            return null;
        }
    }

    public static class AbstractCompositeFilter
    implements Filter {
        private List<Filter> children;

        public AbstractCompositeFilter() {
        }

        public AbstractCompositeFilter(List<Filter> children) {
            this.children = children;
        }

        @Override
        public List<Filter> getChildren() {
            return this.children;
        }

        public void setChildren(List<Filter> children) {
            this.children = children;
        }
    }

    public static interface FilterFactory<T> {
        public T buildFilter(Filter var1);
    }
}

