/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.Accessor;

public class LayeredAccessor<T extends AbstractIdentifiableObject>
implements Accessor<T> {
    private final List<Accessor<T>> accessors = new ArrayList<Accessor<T>>();

    public LayeredAccessor() {
    }

    public LayeredAccessor(List<? extends Accessor<T>> accessors) {
        this.accessors.addAll(accessors);
    }

    public void addAccessor(Accessor<T> accessor) {
        this.accessors.add(accessor);
    }

    public void pushAccessor(Accessor<T> accessor) {
        this.accessors.add(0, accessor);
    }

    @Override
    public T get(ObjectId id) {
        return (T)this.layeredLookup(a -> a.get(id));
    }

    protected <V> V layeredLookup(Function<Accessor<T>, V> f) {
        for (Accessor<T> Accessor2 : this.accessors) {
            V result = f.apply(Accessor2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public T findByCriteria(Map<String, String> criteria) {
        return (T)this.layeredLookup(a -> a.findByCriteria(criteria));
    }

    @Override
    public Stream<T> findManyByCriteria(Map<String, String> criteria) {
        return this.layeredStreamMerge(a -> a.findManyByCriteria(criteria));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return (T)this.layeredLookup(a -> a.findByAttributes(attributes));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        return this.layeredMerge(a -> a.findManyByAttributes(attributes));
    }

    protected <V> Stream<V> layeredStreamMerge(Function<Accessor<T>, Stream<V>> f) {
        return this.accessors.stream().map(a -> (Stream)f.apply((Accessor)a)).flatMap(i -> i);
    }

    protected <V> Spliterator<V> layeredMerge(Function<Accessor<T>, Spliterator<V>> f) {
        ArrayList result = new ArrayList();
        this.accessors.forEach(a -> ((Spliterator)f.apply((Accessor)a)).forEachRemaining(result::add));
        return result.spliterator();
    }

    @Override
    public Iterator<T> getAll() {
        return this.layeredStreamMerge(a -> a.stream()).iterator();
    }

    @Override
    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return (T)this.layeredLookup(a -> a.findByAttributes(attributes, attributesMapKey));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.layeredMerge(a -> a.findManyByAttributes(attributes, attributesMapKey));
    }

    @Override
    public List<T> getRange(int skip, int limit) {
        return this.stream().skip(skip).limit(limit).collect(Collectors.toList());
    }

    @Override
    public void remove(ObjectId id) {
        for (Accessor<T> Accessor2 : this.accessors) {
            T e = Accessor2.get(id);
            if (e == null) continue;
            Accessor2.remove(id);
        }
    }

    @Override
    public T save(T entity) {
        return this.getAccessorForPersistence().save(entity);
    }

    @Override
    public void save(Iterable<T> entities) {
        this.getAccessorForPersistence().save(entities);
    }

    protected Accessor<T> getAccessorForPersistence() {
        return this.accessors.get(0);
    }

    @Override
    public Stream<T> stream() {
        return this.layeredStreamMerge(a -> a.stream());
    }
}

