/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.delegating;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;
import step.core.collections.delegating.DelegatingCollectionFactory;
import step.core.collections.inmemory.InMemoryCollection;

public class DelegatingCollectionFactoryTest {
    @Test
    public void test() throws IOException {
        InMemoryCollection collectionFromFactory1 = new InMemoryCollection();
        CollectionFactory collectionFactory1 = this.newCollectionFactory((InMemoryCollection<Object>)collectionFromFactory1);
        InMemoryCollection collectionFromFactory2 = new InMemoryCollection();
        CollectionFactory collectionFactory2 = this.newCollectionFactory((InMemoryCollection<Object>)collectionFromFactory2);
        DelegatingCollectionFactory collectionFactory = new DelegatingCollectionFactory();
        collectionFactory.addCollectionFactory("factory1", collectionFactory1);
        collectionFactory.addCollectionFactory("factory2", collectionFactory2);
        collectionFactory.addRoute("myCollection1", "factory1");
        collectionFactory.addRoute("myCollection2", "factory2");
        collectionFactory.setDefaultRoute("factory2");
        Collection actualCollection = collectionFactory.getCollection("myCollection1", null);
        Assert.assertTrue((actualCollection == collectionFromFactory1 ? 1 : 0) != 0);
        actualCollection = collectionFactory.getCollection("myCollection2", null);
        Assert.assertTrue((actualCollection == collectionFromFactory2 ? 1 : 0) != 0);
        actualCollection = collectionFactory.getCollection("myCollection3", null);
        Assert.assertTrue((actualCollection == collectionFromFactory2 ? 1 : 0) != 0);
        collectionFactory.setDefaultRoute(null);
        Exception actualException = null;
        try {
            collectionFactory.getCollection("myOtherCollection", null);
        }
        catch (Exception e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)actualException);
        actualException = null;
        try {
            collectionFactory.addRoute("myCollection1", "invalidCollectionId");
        }
        catch (Exception e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)actualException);
        collectionFactory.close();
    }

    private CollectionFactory newCollectionFactory(final InMemoryCollection<Object> collectionFromFactory1) {
        return new CollectionFactory(){

            public void close() throws IOException {
            }

            public <T> Collection<T> getCollection(String name, Class<T> entityClass) {
                return collectionFromFactory1;
            }
        };
    }
}

