/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import step.core.accessors.AbstractAccessorTest;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.CachedAccessor;
import step.core.accessors.InMemoryAccessor;

public class CachedAccessorTest
extends AbstractAccessorTest {
    private InMemoryAccessor<AbstractIdentifiableObject> underlyingAccessor = new InMemoryAccessor();
    private InMemoryAccessor<AbstractOrganizableObject> underlyingOrganisableObjectAccessor = new InMemoryAccessor();

    @Before
    public void before() {
        this.accessor = new CachedAccessor(this.underlyingAccessor);
        this.organizableObjectAccessor = new CachedAccessor(this.underlyingOrganisableObjectAccessor);
    }

    @Test
    public void testCaching() {
        AbstractOrganizableObject entity = new AbstractOrganizableObject();
        this.underlyingAccessor.save((AbstractIdentifiableObject)entity);
        ((CachedAccessor)this.accessor).reloadCache();
        AbstractIdentifiableObject actual = this.accessor.get(entity.getId());
        Assert.assertEquals((Object)entity, (Object)actual);
        AbstractIdentifiableObject entity2 = new AbstractIdentifiableObject();
        this.accessor.save(entity2);
        actual = this.underlyingAccessor.get(entity2.getId());
        Assert.assertEquals((Object)entity2, (Object)actual);
        actual = this.accessor.get(entity2.getId());
        Assert.assertEquals((Object)entity2, (Object)actual);
        this.accessor.remove(entity2.getId());
        actual = this.underlyingAccessor.get(entity2.getId());
        Assert.assertNull((Object)actual);
        actual = this.accessor.get(entity2.getId());
        Assert.assertNull((Object)actual);
    }
}

