/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.maven;

import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import step.controller.multitenancy.Tenant;
import step.controller.multitenancy.client.MultitenancyClient;

public abstract class TenantSwitcher {
    public Tenant switchTenant(String projectName) throws MojoExecutionException {
        Tenant tenant;
        block10: {
            MultitenancyClient multitenancyClient = this.createClient();
            try {
                List availableTenants = multitenancyClient.getAvailableTenants();
                Tenant currentTenant = null;
                if (availableTenants != null) {
                    currentTenant = availableTenants.stream().filter(t -> Objects.equals(t.getName(), projectName)).findFirst().orElse(null);
                }
                if (currentTenant == null) {
                    throw new MojoExecutionException("Unable to resolve tenant by name: " + projectName);
                }
                multitenancyClient.selectTenant(projectName);
                tenant = currentTenant;
                if (multitenancyClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (multitenancyClient != null) {
                        try {
                            multitenancyClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            multitenancyClient.close();
        }
        return tenant;
    }

    protected abstract MultitenancyClient createClient();
}

