/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import scala_maven.ScalaContinuousCompileMojo;
import util.FileUtils;

public class ExtendedScalaContinuousCompileMojo
extends ScalaContinuousCompileMojo {
    public MavenProject getProject() {
        return this.project;
    }

    public List<String> getScalacArgs() throws Exception {
        return super.getScalacOptions();
    }

    public List<File> getCompileSourceDirectories() throws Exception {
        ArrayList<String> mainSources = new ArrayList<String>(this.project.getCompileSourceRoots());
        mainSources.add(FileUtils.pathOf((File)this.mainSourceDir, (boolean)this.useCanonicalPath));
        return this.normalize(mainSources);
    }

    public List<File> getTestSourceDirectories() throws Exception {
        ArrayList<String> testSources = new ArrayList<String>(this.project.getTestCompileSourceRoots());
        testSources.add(FileUtils.pathOf((File)this.testSourceDir, (boolean)this.useCanonicalPath));
        return this.normalize(testSources);
    }

    public File getCompileOutputDir() throws Exception {
        this.mainOutputDir = FileUtils.fileOf((File)this.mainOutputDir, (boolean)this.useCanonicalPath);
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        return this.mainOutputDir;
    }

    public File getTestOutputDir() throws Exception {
        this.testOutputDir = FileUtils.fileOf((File)this.testOutputDir, (boolean)this.useCanonicalPath);
        if (!this.testOutputDir.exists()) {
            this.testOutputDir.mkdirs();
        }
        return this.testOutputDir;
    }

    public Boolean getFork() {
        return this.fork;
    }

    public File getCompileAnalysisCacheFile() throws Exception {
        return FileUtils.fileOf((File)this.analysisCacheFile, (boolean)this.useCanonicalPath);
    }

    public File getTestAnalysisCacheFile() throws Exception {
        return FileUtils.fileOf((File)this.testAnalysisCacheFile, (boolean)this.useCanonicalPath);
    }

    public File getJavaHome() throws Exception {
        String _javaExec = null;
        Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            _javaExec = toolchain.findTool("java");
        }
        if (toolchain == null || _javaExec == null) {
            _javaExec = System.getProperty("java.home");
            if (_javaExec == null && (_javaExec = System.getenv("JAVA_HOME")) == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
            _javaExec = _javaExec + File.separator + "bin" + File.separator + "java";
        }
        return new File(_javaExec);
    }
}

