/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.response;

import com.thoughtworks.go.plugin.api.response.GoPluginApiResponse;
import java.util.HashMap;
import java.util.Map;

public class DefaultGoPluginApiResponse
extends GoPluginApiResponse {
    public static final int SUCCESS_RESPONSE_CODE = 200;
    public static final int VALIDATION_FAILED = 412;
    public static final int BAD_REQUEST = 400;
    public static final int INTERNAL_ERROR = 500;
    private int responseCode;
    private Map<String, String> responseHeaders;
    private String responseBody;

    public DefaultGoPluginApiResponse(int responseCode) {
        this(responseCode, null, new HashMap<String, String>());
    }

    public DefaultGoPluginApiResponse(int responseCode, String responseBody) {
        this(responseCode, responseBody, new HashMap<String, String>());
    }

    public DefaultGoPluginApiResponse(int responseCode, String responseBody, Map<String, String> responseHeaders) {
        this.responseCode = responseCode;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
    }

    public static DefaultGoPluginApiResponse incompleteRequest(String responseBody) {
        return new DefaultGoPluginApiResponse(412, responseBody);
    }

    public static DefaultGoPluginApiResponse badRequest(String responseBody) {
        return new DefaultGoPluginApiResponse(400, responseBody);
    }

    public static DefaultGoPluginApiResponse error(String responseBody) {
        return new DefaultGoPluginApiResponse(500, responseBody);
    }

    public static DefaultGoPluginApiResponse success(String responseBody) {
        return new DefaultGoPluginApiResponse(200, responseBody);
    }

    public void addResponseHeader(String name, String value) {
        this.responseHeaders.put(name, value);
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    @Override
    public int responseCode() {
        return this.responseCode;
    }

    @Override
    public Map<String, String> responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public String responseBody() {
        return this.responseBody;
    }
}

