/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.io.IOException;
import java.io.Reader;
import jsonij.ConstantUtility;
import jsonij.parser.BaseJSONReader;
import jsonij.parser.JSONParserException;
import jsonij.parser.JSONReader;
import jsonij.parser.ParserException;
import jsonij.parser.Position;

public class ReaderJSONReader
extends BaseJSONReader
implements JSONReader {
    protected Reader reader;
    ReaderJSONStringReader stringReader;
    private int peekRead;

    public ReaderJSONReader(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("Null Reader Exception.");
        }
        this.reader = reader;
        this.peekRead = -1;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int readNext() throws ParserException {
        try {
            int r = -1;
            while (this.peekRead != -1 || this.reader.ready() && (r = this.reader.read()) != -1) {
                int peekR;
                if (this.peekRead != -1) {
                    r = this.peekRead;
                    this.peekRead = -1;
                }
                this.position.movePosition();
                if (ConstantUtility.isComment(r) && this.reader.ready() && (peekR = this.reader.read()) != -1) {
                    if (ConstantUtility.isComment(peekR)) {
                        do {
                            r = this.reader.read();
                            this.position.movePosition();
                        } while (r != -1 && !ConstantUtility.isReturn(r) && !ConstantUtility.isNewLine(r));
                    } else {
                        this.peekRead = peekR;
                        break;
                    }
                }
                if (ConstantUtility.isReturn(r)) {
                    this.handleNewLine();
                    r = this.reader.read();
                    if (ConstantUtility.isNewLine(r)) {
                        r = this.reader.read();
                    }
                }
                if (ConstantUtility.isNewLine(r)) {
                    this.handleNewLine();
                    r = this.reader.read();
                }
                if (ConstantUtility.isComment(r)) {
                    this.peekRead = r;
                    continue;
                }
                if (ConstantUtility.isWhiteSpace(r) || ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r)) continue;
            }
            return r;
        }
        catch (IOException ex) {
            throw new JSONParserException("readNext", this.getLineNumber(), this.getPositionNumber(), new Object[]{ex});
        }
    }

    @Override
    public JSONReader getStringReader(JSONReader.Mode mode) {
        if (this.stringReader == null) {
            this.stringReader = new ReaderJSONStringReader();
        } else if (this.stringReader.isActive()) {
            // empty if block
        }
        this.stringReader.setMode(mode);
        this.stringReader.setActive(true);
        return this.stringReader;
    }

    protected class ReaderJSONStringReader
    implements JSONReader {
        protected JSONReader.Mode mode = JSONReader.Mode.QUOTED_READING;
        protected boolean active = true;

        public JSONReader.Mode getMode() {
            return this.mode;
        }

        public void setMode(JSONReader.Mode mode) {
            this.mode = mode;
        }

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public int peek() throws ParserException {
            if (!ReaderJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                ReaderJSONReader.this.peekValue = this.readNext();
                ReaderJSONReader.this.hasPeeked = true;
            }
            return ReaderJSONReader.this.peekValue;
        }

        @Override
        public int read() throws ParserException {
            if (ReaderJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                ReaderJSONReader.this.hasPeeked = false;
                return ReaderJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        @Override
        public void close() {
            this.active = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int readNext() throws ParserException {
            int r = -1;
            try {
                while (true) {
                    int peekR;
                    if (ReaderJSONReader.this.peekRead == -1) {
                        if (!ReaderJSONReader.this.reader.ready()) return r;
                        r = ReaderJSONReader.this.reader.read();
                        if (r == -1) return r;
                    }
                    if (ReaderJSONReader.this.peekRead != -1) {
                        r = ReaderJSONReader.this.peekRead;
                        ReaderJSONReader.this.peekRead = -1;
                    }
                    ReaderJSONReader.this.position.movePosition();
                    if (ConstantUtility.isComment(r) && ReaderJSONReader.this.reader.ready() && (peekR = ReaderJSONReader.this.reader.read()) != -1) {
                        if (!ConstantUtility.isComment(peekR)) {
                            ReaderJSONReader.this.peekRead = peekR;
                            return r;
                        }
                        do {
                            r = ReaderJSONReader.this.reader.read();
                            ReaderJSONReader.this.position.movePosition();
                        } while (r != -1 && !ConstantUtility.isReturn(r) && !ConstantUtility.isNewLine(r));
                    }
                    if (ConstantUtility.isReturn(r)) {
                        ReaderJSONReader.this.handleNewLine();
                        r = ReaderJSONReader.this.reader.read();
                        if (ConstantUtility.isNewLine(r)) {
                            r = ReaderJSONReader.this.reader.read();
                        }
                    }
                    if (ConstantUtility.isNewLine(r)) {
                        ReaderJSONReader.this.handleNewLine();
                        r = ReaderJSONReader.this.reader.read();
                    }
                    if (ConstantUtility.isComment(r)) {
                        ReaderJSONReader.this.peekRead = r;
                        continue;
                    }
                    if (!ConstantUtility.isReturn(r) && !ConstantUtility.isNewLine(r)) break;
                }
                return r;
            }
            catch (IOException ex) {
                throw new JSONParserException("readNext", this.getLineNumber(), this.getPositionNumber(), new Object[]{ex});
            }
        }

        @Override
        public Position getPosition() {
            return ReaderJSONReader.this.getPosition();
        }

        @Override
        public boolean isHasPeeked() {
            return ReaderJSONReader.this.isHasPeeked();
        }

        @Override
        public boolean hasPeeked() {
            return ReaderJSONReader.this.hasPeeked();
        }

        @Override
        public void setHasPeeked(boolean hasPeeked) {
            ReaderJSONReader.this.setHasPeeked(hasPeeked);
        }

        @Override
        public int getLineNumber() {
            return ReaderJSONReader.this.getLineNumber();
        }

        @Override
        public int getPositionNumber() {
            return ReaderJSONReader.this.getPositionNumber();
        }

        @Override
        public JSONReader getStringReader(JSONReader.Mode mode) {
            return this;
        }
    }
}

