/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath.predicate;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsonij.Value;
import jsonij.ValueType;
import jsonij.jpath.JPathRuntimeException;
import jsonij.jpath.predicate.Function;
import jsonij.jpath.predicate.FunctionArgument;

public class RegexFunction
extends Function {
    public RegexFunction() {
        this.functionName = "regex";
        this.argumentTypeList = new ArrayList();
        this.argumentTypeList.add(FunctionArgument.AttributeArgument.class);
        this.argumentTypeList.add(FunctionArgument.ValueArgument.class);
    }

    @Override
    public Value evaluate(FunctionArgument[] args, Value value) {
        if (Array.getLength(args) != 2) {
            throw new JPathRuntimeException("InvalidArgCount", new Object[0]);
        }
        if (args[0] == null || args[0].type != FunctionArgument.ARGUMENT_TYPE.ATTRIBUTE) {
            throw new JPathRuntimeException("InvalidArg", args[0]);
        }
        if (args[1] == null || args[1].type != FunctionArgument.ARGUMENT_TYPE.VALUE) {
            throw new JPathRuntimeException("InvalidArg", args[1]);
        }
        String attributeName = ((FunctionArgument.AttributeArgument)args[0]).getAttributeName();
        if (!value.has(attributeName)) {
            return null;
        }
        Value regexValue = ((FunctionArgument.ValueArgument)args[1]).getValue();
        if (regexValue.getValueType() != ValueType.STRING) {
            throw new JPathRuntimeException("InvalidArg", args[1]);
        }
        Value matchValue = value.get(attributeName);
        Pattern pattern = Pattern.compile(regexValue.getString());
        Matcher matcher = pattern.matcher(matchValue.getString());
        if (matcher.matches()) {
            return matchValue;
        }
        return null;
    }
}

