/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Set;
import jsonij.JSON;
import jsonij.ValueType;

public abstract class Value
implements Serializable,
Comparable<Value> {
    private static final long serialVersionUID = 2774919263250085887L;
    protected ValueType valueType = this.internalType();

    public Value() {
        if (this.valueType == null) {
            throw new NullPointerException("type() method must be implemented and return a valid type.");
        }
    }

    public abstract ValueType internalType();

    public ValueType getValueType() {
        return this.valueType;
    }

    public ValueType type() {
        return this.valueType;
    }

    public int size() {
        switch (this.valueType) {
            case STRING: {
                return ((JSON.String)this).length();
            }
            case ARRAY: {
                return ((JSON.Array)this).size();
            }
            case OBJECT: {
                return ((JSON.Object)this).size();
            }
        }
        return -1;
    }

    public abstract int nestedSize();

    public boolean isNull() {
        switch (this.valueType) {
            case NULL: {
                return true;
            }
        }
        return !this.getBoolean();
    }

    public boolean getBoolean() {
        boolean result = false;
        switch (this.valueType) {
            case TRUE: {
                result = true;
                break;
            }
            case FALSE: {
                result = false;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue() != 0;
                break;
            }
            case STRING: {
                result = ((JSON.String)this).length() != 0;
                break;
            }
            case ARRAY: {
                result = !((JSON.Array)this).isEmpty();
                break;
            }
            case OBJECT: {
                result = !((JSON.Object)this).isEmpty();
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public int getInt() {
        int result;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue();
                break;
            }
            case TRUE: {
                result = 1;
                break;
            }
            case FALSE: {
                result = 0;
                break;
            }
            case STRING: {
                result = Integer.parseInt(this.toString());
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public double getDouble() {
        double result;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).doubleValue();
                break;
            }
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
                break;
            }
            default: {
                result = -1.0;
            }
        }
        return result;
    }

    public long getLong() {
        long result;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).longValue();
                break;
            }
            case TRUE: {
                result = 1L;
                break;
            }
            case FALSE: {
                result = 0L;
                break;
            }
            case STRING: {
                result = Long.parseLong(this.toString());
                break;
            }
            default: {
                result = -1L;
            }
        }
        return result;
    }

    public Number getNumber() {
        Number result;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).getNumber();
                break;
            }
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
                break;
            }
            default: {
                result = -1.0;
            }
        }
        return result;
    }

    public String getString() {
        String result;
        switch (this.valueType) {
            case STRING: {
                result = this.toString();
                break;
            }
            case TRUE: {
                result = "true";
                break;
            }
            case FALSE: {
                result = "false";
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).toString();
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).toString();
                break;
            }
            case ARRAY: {
                result = ((JSON.Array)this).toString();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Value get(int i) {
        Object result;
        switch (this.valueType) {
            case ARRAY: {
                result = ((JSON.Array)this).get(i);
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).get(i);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public boolean has(String key) {
        boolean result;
        switch (this.valueType) {
            case OBJECT: {
                result = ((JSON.Object)this).containsKey(new JSON.String(key));
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public Set<CharSequence> valueKeySet() {
        Set keys;
        switch (this.valueType) {
            case OBJECT: {
                keys = ((JSON.Object)this).mapValue.keySet();
                break;
            }
            default: {
                keys = null;
            }
        }
        return keys;
    }

    public Value get(CharSequence key) {
        Value result;
        switch (this.valueType) {
            case OBJECT: {
                result = (Value)((JSON.Object)this).safeGet(key.toString());
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public abstract String toJSON();

    public abstract ByteBuffer toBSON(ByteBuffer var1);

    public abstract ByteBuffer toUniversalBinaryJSON(ByteBuffer var1);

    public String toString() {
        return this.toJSON();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value o = (Value)obj;
        boolean equalsResult = false;
        if (null != this.internalType()) {
            block0 : switch (this.internalType()) {
                case OBJECT: {
                    if (o.internalType() == ValueType.OBJECT) {
                        if (o.size() == this.size()) {
                            equalsResult = true;
                            for (CharSequence key : this.valueKeySet()) {
                                Value thisValue = this.get(key);
                                Value otherValue = o.get(key);
                                if (otherValue == null || thisValue.equals(otherValue)) continue;
                                equalsResult = false;
                                break block0;
                            }
                            break;
                        }
                        equalsResult = false;
                        break;
                    }
                    equalsResult = this.toString().equals(o.toString());
                    break;
                }
                case ARRAY: {
                    if (o.internalType() == ValueType.ARRAY) {
                        if (o.size() == this.size()) {
                            equalsResult = true;
                            for (int i = 0; i < this.size(); ++i) {
                                if (this.get(i).equals(o.get(i))) continue;
                                equalsResult = false;
                                break block0;
                            }
                            break;
                        }
                        equalsResult = false;
                        break;
                    }
                    equalsResult = this.toString().equals(o.toString());
                    break;
                }
                case NULL: {
                    equalsResult = this.isNull() && o.isNull();
                    break;
                }
                case TRUE: 
                case FALSE: {
                    equalsResult = this.getBoolean() == o.getBoolean();
                    break;
                }
                case NUMERIC: {
                    Number thisNumber = this.getNumber();
                    Number otherNumber = o.getNumber();
                    if (thisNumber == null || otherNumber == null) break;
                    equalsResult = thisNumber.equals(otherNumber);
                    break;
                }
                case STRING: {
                    equalsResult = this.getString().equals(o.getString());
                    break;
                }
            }
        }
        return equalsResult;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.valueType != null ? this.valueType.hashCode() : 0);
        if (null != this.internalType()) {
            switch (this.internalType()) {
                case OBJECT: {
                    for (int i = 0; i < this.size(); ++i) {
                        hash = 13 * hash + this.get(i).hashCode();
                    }
                    break;
                }
                case ARRAY: {
                    for (int i = 0; i < this.size(); ++i) {
                        hash = 13 * hash + this.get(i).hashCode();
                    }
                    break;
                }
                case NULL: {
                    hash = 13 * hash + JSON.NULL.hashCode();
                    break;
                }
                case TRUE: {
                    hash = 13 * hash + JSON.TRUE.hashCode();
                    break;
                }
                case FALSE: {
                    hash = 13 * hash + JSON.FALSE.hashCode();
                    break;
                }
                case NUMERIC: {
                    hash = 13 * hash + this.getNumber().hashCode();
                    break;
                }
                case STRING: {
                    hash = this.getString() != null ? this.getString().hashCode() : 0;
                    break;
                }
            }
        }
        return hash;
    }

    @Override
    public int compareTo(Value o) {
        int compare = 0;
        if (null != this.internalType()) {
            switch (this.internalType()) {
                case OBJECT: {
                    if (o.internalType() == ValueType.NULL || o.internalType() == ValueType.TRUE || o.internalType() == ValueType.FALSE) {
                        compare = 1;
                        break;
                    }
                    compare = this.toJSON().compareTo(o.toJSON());
                    break;
                }
                case ARRAY: {
                    if (o.internalType() == ValueType.NULL || o.internalType() == ValueType.TRUE || o.internalType() == ValueType.FALSE || o.internalType() == ValueType.OBJECT) {
                        compare = 1;
                        break;
                    }
                    compare = this.toJSON().compareTo(o.toJSON());
                    break;
                }
                case NULL: {
                    if (o.internalType() == ValueType.NULL) {
                        compare = 0;
                        break;
                    }
                    compare = -1;
                    break;
                }
                case TRUE: {
                    if (o.internalType() == ValueType.NULL) {
                        compare = 1;
                        break;
                    }
                    if (o.internalType() == ValueType.TRUE) {
                        compare = 0;
                        break;
                    }
                    compare = -1;
                    break;
                }
                case FALSE: {
                    if (o.internalType() == ValueType.NULL) {
                        compare = 1;
                        break;
                    }
                    if (o.internalType() == ValueType.TRUE) {
                        compare = 1;
                        break;
                    }
                    if (o.internalType() == ValueType.FALSE) {
                        compare = 0;
                        break;
                    }
                    compare = -1;
                    break;
                }
                case NUMERIC: {
                    double thisDouble = this.getDouble();
                    double thatDouble = o.getDouble();
                    if (thisDouble < thatDouble) {
                        compare = -1;
                        break;
                    }
                    if (thisDouble == thatDouble) {
                        compare = 0;
                        break;
                    }
                    if (!(thisDouble > thatDouble)) break;
                    compare = 1;
                    break;
                }
                case STRING: {
                    compare = this.getString().compareTo(o.getString());
                    break;
                }
            }
        }
        return compare;
    }
}

