/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.reflect;

import cc.plural.jsonij.marshal.annotation.JSONCollector;
import cc.plural.jsonij.marshal.annotation.JSONName;
import cc.plural.jsonij.reflect.ClassProperty;
import cc.plural.jsonij.reflect.Inspection;
import cc.plural.jsonij.reflect.InspectionFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionFactory {
    public InspectionFilter filter = InspectionFilter.getDefaultFilters();
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";

    public Inspection inspect(Object object) {
        return this.inspect(object.getClass());
    }

    public Inspection inspect(Class<?> klass) {
        if (klass == null) {
            throw new NullPointerException();
        }
        ArrayList<ClassProperty> tempProperties = new ArrayList<ClassProperty>();
        Class<?> currentClass = klass;
        do {
            if (this.filter.isFiltered(currentClass)) continue;
            List<ClassProperty> currentClassProperties = this.inspectClassProperties(currentClass);
            for (ClassProperty currentClassProperty : currentClassProperties) {
                if (tempProperties.contains(currentClassProperty)) continue;
                tempProperties.add(currentClassProperty);
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        ArrayList<ClassProperty> classProperties = new ArrayList<ClassProperty>();
        ArrayList<ClassProperty> collectorProperties = new ArrayList<ClassProperty>();
        for (ClassProperty property : tempProperties) {
            if (property.isValid() && !classProperties.contains(property)) {
                classProperties.add(property);
            }
            if (!property.isValid() || !property.isCollector() || collectorProperties.contains(property)) continue;
            collectorProperties.add(property);
        }
        Inspection inspection = new Inspection();
        inspection.setKlass(klass);
        inspection.setProperties(classProperties);
        inspection.setInnerList(InspectionFactory.isListType(klass));
        inspection.setInnerMap(InspectionFactory.isMapType(klass));
        inspection.setCollectors(collectorProperties);
        return inspection;
    }

    private List<ClassProperty> inspectClassProperties(Class<?> klass) {
        Method[] methods;
        Field[] fields;
        HashMap<String, ClassProperty> propertyMap = new HashMap<String, ClassProperty>();
        for (Field field : fields = klass.getDeclaredFields()) {
            ClassProperty property = new ClassProperty();
            property.setKlass(klass);
            String propertyName = field.getName();
            if (field.isAnnotationPresent(JSONName.class)) {
                JSONName jsonName = field.getAnnotation(JSONName.class);
                propertyName = jsonName.value();
            }
            if (field.isAnnotationPresent(JSONCollector.class)) {
                property.setCollector(true);
            }
            property.setPropertyName(propertyName);
            property.registerAccessor(field);
            property.registorMutator(field);
            propertyMap.put(propertyName, property);
        }
        for (Method method : methods = klass.getDeclaredMethods()) {
            ClassProperty property;
            char ch;
            String propertyName = null;
            String methodName = method.getName();
            boolean collector = false;
            Class<?> returnType = method.getReturnType();
            if (methodName.length() > IS_PREFIX.length() && methodName.startsWith(IS_PREFIX) && returnType == Boolean.TYPE && Character.isUpperCase(ch = methodName.charAt(IS_PREFIX.length()))) {
                if (method.isAnnotationPresent(JSONName.class)) {
                    JSONName jsonName = method.getAnnotation(JSONName.class);
                    propertyName = jsonName.value();
                } else {
                    propertyName = Character.toLowerCase(ch) + methodName.substring(IS_PREFIX.length() + 1, methodName.length());
                }
                if (method.isAnnotationPresent(JSONCollector.class)) {
                    collector = true;
                }
                property = null;
                if (propertyMap.containsKey(propertyName)) {
                    property = (ClassProperty)propertyMap.get(propertyName);
                    property.registerAccessor(method);
                    continue;
                }
                property = new ClassProperty();
                property.setKlass(klass);
                property.setPropertyName(propertyName);
                property.registerAccessor(method);
                propertyMap.put(propertyName, property);
                property.setCollector(collector);
                continue;
            }
            if (methodName.length() > SET_PREFIX.length() && methodName.startsWith(SET_PREFIX) && Character.isUpperCase(ch = methodName.charAt(SET_PREFIX.length()))) {
                propertyName = Character.toLowerCase(ch) + methodName.substring(SET_PREFIX.length() + 1, methodName.length());
                property = null;
                if (propertyMap.containsKey(propertyName)) {
                    property = (ClassProperty)propertyMap.get(propertyName);
                    property.registorMutator(method);
                    continue;
                }
                property = new ClassProperty();
                property.setKlass(klass);
                property.setPropertyName(propertyName);
                property.registorMutator(method);
                propertyMap.put(propertyName, property);
                continue;
            }
            if (methodName.length() <= GET_PREFIX.length() || !methodName.startsWith(GET_PREFIX) || !Character.isUpperCase(ch = methodName.charAt(GET_PREFIX.length())) || returnType == null) continue;
            propertyName = Character.toLowerCase(ch) + methodName.substring(GET_PREFIX.length() + 1, methodName.length());
            property = null;
            if (propertyMap.containsKey(propertyName)) {
                property = (ClassProperty)propertyMap.get(propertyName);
                property.registerAccessor(method);
                continue;
            }
            property = new ClassProperty();
            property.setKlass(klass);
            property.setPropertyName(propertyName);
            property.registerAccessor(method);
            propertyMap.put(propertyName, property);
        }
        ArrayList<ClassProperty> propertyList = new ArrayList<ClassProperty>();
        propertyList.addAll(propertyMap.values());
        return propertyList;
    }

    public static boolean isMapType(Class<?> c) {
        Class<?> currentClass = c;
        do {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = currentClass.getInterfaces()) {
                if (i != Map.class) continue;
                return true;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return false;
    }

    public static boolean isListType(Class<?> c) {
        Class<?> currentClass = c;
        do {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = currentClass.getInterfaces()) {
                if (i != List.class) continue;
                return true;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return false;
    }
}

