/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.jpath;

import cc.plural.jsonij.Value;
import cc.plural.jsonij.jpath.PredicateComponent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionPredicate
extends PredicateComponent {
    public final int CAPACITY_GROWTH_FACTOR = 10;
    int capacity;
    int current;
    int[] indexes;

    public UnionPredicate() {
        this.capacity = 10;
        this.current = 0;
        this.indexes = new int[this.capacity];
    }

    public UnionPredicate(int[] indexes) {
        this.current = this.capacity = Array.getLength(indexes);
        this.indexes = indexes;
    }

    public int[] getIndexes() {
        if (this.capacity == this.current) {
            return this.indexes;
        }
        int[] result = new int[this.current];
        System.arraycopy(this.indexes, 0, result, 0, this.current);
        return result;
    }

    public void setIndexes(int[] indexes) {
        this.current = this.capacity = Array.getLength(indexes);
        this.indexes = indexes;
    }

    public boolean containsIndex(int index) {
        boolean result = false;
        for (int i = 0; i < this.current; ++i) {
            if (this.indexes[i] != index) continue;
            result = true;
            break;
        }
        return result;
    }

    public void addIndex(int index) {
        if (!this.containsIndex(index)) {
            if (this.current < this.capacity) {
                this.indexes[this.current] = index;
                ++this.current;
            } else {
                int[] newIndexes = new int[this.capacity + 10];
                System.arraycopy(this.indexes, 0, newIndexes, 0, this.current);
                this.capacity += 10;
                newIndexes[this.current] = index;
                this.indexes = newIndexes;
                ++this.current;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnionPredicate other = (UnionPredicate)obj;
        return Arrays.equals(this.getIndexes(), other.getIndexes());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Arrays.hashCode(this.getIndexes());
        return hash;
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        for (Value value : values) {
            int currentValueSize = value.size();
            for (int j = 0; j < Array.getLength(this.indexes); ++j) {
                if (this.indexes[j] >= 0 && this.indexes[j] < currentValueSize) {
                    results.add(value.get(this.indexes[j]));
                    continue;
                }
                if (this.indexes[j] >= 0 || currentValueSize - this.indexes[j] < 0) continue;
                results.add(value.get(currentValueSize + this.indexes[j]));
            }
        }
        return results;
    }
}

