/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.jpath;

import cc.plural.jsonij.Value;
import cc.plural.jsonij.jpath.PredicateComponent;
import cc.plural.jsonij.jpath.functions.FunctionArgument;
import cc.plural.jsonij.jpath.functions.RegexFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPredicate
extends PredicateComponent {
    String expression = null;
    ArrayList<ExpressionPredicateCondition> conditions = new ArrayList();

    public ArrayList<ExpressionPredicateCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(ArrayList<ExpressionPredicateCondition> conditions) {
        this.conditions = conditions;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ArrayList<ExpressionPredicateCondition> conditions() {
        return this.conditions;
    }

    public String toString() {
        StringBuilder conditionString = new StringBuilder();
        for (ExpressionPredicateCondition epc : this.conditions()) {
            conditionString.append(epc);
            conditionString.append(" ");
        }
        String output = String.format("ExpressionPredicate (\"%s\" -> %s)", this.getExpression(), conditionString);
        return output;
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        for (Value value : values) {
            if (value.getValueType() == Value.TYPE.ARRAY) {
                for (int j = 0; j < value.size(); ++j) {
                    Value checkElement = value.get(j);
                    if (checkElement.getValueType() != Value.TYPE.OBJECT) continue;
                    boolean expressionValid = true;
                    for (ExpressionPredicateCondition condition : this.conditions) {
                        RegexFunction regexFunction;
                        Value result;
                        if (condition instanceof OperatorExpressionPredicateCondition) {
                            OperatorExpressionPredicateCondition operatorCondition = (OperatorExpressionPredicateCondition)condition;
                            Value checkValue = checkElement.get(operatorCondition.getAttribute());
                            if (checkValue == null) {
                                expressionValid = false;
                                break;
                            }
                            ExpressionPredicateOperator expressionConditionOperator = operatorCondition.getOperator();
                            if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.NOT_NULL)) {
                                if (!checkValue.isNull()) continue;
                                expressionValid = false;
                                break;
                            }
                            if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.EQUAL)) {
                                if (checkValue.equals(operatorCondition.value)) continue;
                                expressionValid = false;
                                break;
                            }
                            if (!expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS_EQUAL) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER_EQUAL)) continue;
                        }
                        if (!(condition instanceof FunctionExpressionPredicateCondition)) continue;
                        FunctionExpressionPredicateCondition functionCondition = (FunctionExpressionPredicateCondition)condition;
                        String functionName = functionCondition.getFunctionName();
                        FunctionArgument[] funtionArguments = functionCondition.getArguments();
                        if (!functionName.equals("regex") || (result = (regexFunction = new RegexFunction()).evaluate(funtionArguments, checkElement)) != null) continue;
                        expressionValid = false;
                        break;
                    }
                    if (!expressionValid) continue;
                    results.add(checkElement);
                }
                continue;
            }
            if (value.getValueType() != Value.TYPE.OBJECT) continue;
            boolean expressionValid = true;
            for (ExpressionPredicateCondition condition : this.conditions) {
                RegexFunction regexFunction;
                Value result;
                if (condition instanceof OperatorExpressionPredicateCondition) {
                    OperatorExpressionPredicateCondition operatorCondition = (OperatorExpressionPredicateCondition)condition;
                    Value checkValue = value.get(operatorCondition.getAttribute());
                    if (checkValue == null) {
                        expressionValid = false;
                        break;
                    }
                    ExpressionPredicateOperator expressionConditionOperator = operatorCondition.getOperator();
                    if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.NOT_NULL)) {
                        if (!checkValue.isNull()) continue;
                        expressionValid = false;
                        break;
                    }
                    if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.EQUAL)) {
                        if (checkValue.equals(operatorCondition.value)) continue;
                        expressionValid = false;
                        break;
                    }
                    if (!expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS_EQUAL) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER_EQUAL)) continue;
                }
                if (!(condition instanceof FunctionExpressionPredicateCondition)) continue;
                FunctionExpressionPredicateCondition functionCondition = (FunctionExpressionPredicateCondition)condition;
                String functionName = functionCondition.getFunctionName();
                FunctionArgument[] funtionArguments = functionCondition.getArguments();
                if (!functionName.equals("regex") || (result = (regexFunction = new RegexFunction()).evaluate(funtionArguments, value)) == null) continue;
                results.add(value);
            }
            if (!expressionValid) continue;
            results.add(value);
        }
        return results;
    }

    public static class FunctionExpressionPredicateCondition
    extends ExpressionPredicateCondition {
        String functionName;
        FunctionArgument[] arguments;

        public FunctionExpressionPredicateCondition(String functionName, FunctionArgument[] arguments) {
            this.functionName = functionName;
            this.arguments = arguments;
        }

        public FunctionArgument[] getArguments() {
            return this.arguments;
        }

        public void setArguments(FunctionArgument[] arguments) {
            this.arguments = arguments;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public String toString() {
            StringBuilder argumentStringBuilder = new StringBuilder();
            FunctionArgument argValue = null;
            int argCount = Array.getLength(this.arguments);
            if (argCount > 0) {
                for (int i = 0; i < argCount - 1; ++i) {
                    argValue = this.arguments[i];
                    if (argValue != null) {
                        argumentStringBuilder.append(argValue.toString()).append(',');
                        continue;
                    }
                    argumentStringBuilder.append("null").append(',');
                }
                argValue = this.arguments[argCount - 1];
                if (argValue != null) {
                    argumentStringBuilder.append(argValue.toString());
                } else {
                    argumentStringBuilder.append("null");
                }
            }
            return String.format("FunctionExpressionPredicateCondition (%s[%s])", this.functionName, argumentStringBuilder.toString());
        }
    }

    public static class OperatorExpressionPredicateCondition
    extends ExpressionPredicateCondition {
        ExpressionPredicateCombineOperator combine;
        String attribute;
        ExpressionPredicateOperator operator;
        Value value;

        public OperatorExpressionPredicateCondition() {
            this.combine = null;
            this.attribute = null;
            this.operator = null;
            this.value = null;
        }

        public OperatorExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = null;
        }

        public OperatorExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator, Value value) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public OperatorExpressionPredicateCondition(ExpressionPredicateCombineOperator combine, String attribute, ExpressionPredicateOperator operator, Value value) {
            this.combine = combine;
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public ExpressionPredicateCombineOperator getCombine() {
            return this.combine;
        }

        public void setCombine(ExpressionPredicateCombineOperator combine) {
            this.combine = combine;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public ExpressionPredicateOperator getOperator() {
            return this.operator;
        }

        public void setOperator(ExpressionPredicateOperator operator) {
            this.operator = operator;
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public String toString() {
            return String.format("OperatorExpressionPredicateCondition (%s%s %s %s)", new Object[]{this.combine != null ? String.format("%s ", new Object[]{this.combine}) : "", this.attribute, this.operator, this.value.toJSON()});
        }
    }

    public static class ExpressionPredicateCondition {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateCombineOperator {
        AND,
        OR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateOperator {
        NOT_NULL,
        EQUAL,
        LESS,
        GREATER,
        LESS_EQUAL,
        GREATER_EQUAL;

    }
}

