/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.marshal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jsonij.json.JSON;
import jsonij.json.Value;
import jsonij.json.marshal.Inspector;
import jsonij.json.marshal.InspectorProperty;
import jsonij.json.marshal.JSONCodec;
import jsonij.json.marshal.JSONCodecStore;
import jsonij.json.marshal.JavaMarshaler;
import jsonij.json.marshal.annotation.JSONEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObjectMarshaler {
    protected JavaMarshaler marshaler;
    protected final Map<Class<?>, Inspector> inspectedClasses;
    static JSONCodecStore codecStore;
    static int cycleLevels;

    public JavaObjectMarshaler(JavaMarshaler marshaler) {
        this.marshaler = marshaler;
        this.inspectedClasses = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectType(Class<?> objectClass) {
        Inspector inspector = null;
        Map<Class<?>, Inspector> map = this.inspectedClasses;
        synchronized (map) {
            if (this.inspectedClasses.containsKey(objectClass)) {
                inspector = this.inspectedClasses.get(objectClass);
            } else {
                inspector = new Inspector(objectClass);
                inspector.inspect();
                this.inspectedClasses.put(objectClass, inspector);
            }
        }
        InspectorProperty[] properties = inspector.getProperties();
        return properties != null && Array.getLength(properties) > 0 || inspector.hasInnerArray() || inspector.hasInnerObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value marshalJavaObject(Object o, JavaMarshaler.CycleDetector cycleDetector) {
        Method[] methods;
        Class<?> objectClass = o.getClass();
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            if (method.getAnnotation(JSONEncoder.class) == null) continue;
        }
        if (codecStore != null && codecStore.hasCodec(objectClass)) {
            JSONCodec<?> codec = codecStore.getCodec(objectClass);
            Value value = codec.encode(o);
            return value;
        }
        Inspector inspector = null;
        Map<Class<?>, Inspector> value = this.inspectedClasses;
        synchronized (value) {
            if (this.inspectedClasses.containsKey(objectClass)) {
                inspector = this.inspectedClasses.get(objectClass);
            } else {
                inspector = new Inspector(o);
                inspector.inspect();
                this.inspectedClasses.put(objectClass, inspector);
            }
        }
        HashMap<String, Value> valueCollector = new HashMap<String, Value>();
        InspectorProperty[] properties = inspector.getProperties();
        String name = null;
        Value value2 = null;
        int propCount = 0;
        for (InspectorProperty property : properties) {
            block24: {
                String accessorName;
                if (!property.hasAccessor()) continue;
                name = property.getPropertyName();
                if (property.getAccessPropertyType() == InspectorProperty.TYPE.METHOD) {
                    accessorName = property.getAccessName();
                    try {
                        Method method = objectClass.getMethod(accessorName, new Class[0]);
                        value2 = this.marshalObjectMethodValue(method, o, cycleDetector);
                        if (value2 == null) {
                            continue;
                        }
                        break block24;
                    }
                    catch (Exception ex) {
                        value2 = new JSON.String(ex.toString());
                        break block24;
                    }
                }
                if (property.getAccessPropertyType() == InspectorProperty.TYPE.FIELD) {
                    accessorName = property.getAccessName();
                    try {
                        Field field = objectClass.getField(accessorName);
                        value2 = this.marshalObjectFieldValue(field, o, cycleDetector);
                        if (value2 == null) {
                            continue;
                        }
                        break block24;
                    }
                    catch (Exception ex) {
                        value2 = new JSON.String(ex.toString());
                        break block24;
                    }
                }
                value2 = JSON.NULL;
            }
            ++propCount;
            valueCollector.put(name, value2);
        }
        if (inspector.hasInnerArray()) {
            if (propCount > 0) {
                valueCollector.put("innerArray", this.marshaler.marshalJavaList(o, cycleDetector));
            } else {
                return this.marshaler.marshalJavaList(o, cycleDetector);
            }
        }
        if (inspector.hasInnerObject()) {
            if (propCount > 0) {
                valueCollector.put("innerObject", this.marshaler.marshalJavaMap(o, cycleDetector));
            } else {
                return this.marshaler.marshalJavaMap(o, cycleDetector);
            }
        }
        if (valueCollector.isEmpty()) {
            return null;
        }
        JSON.Object<JSON.String, Value> marshaledObject = new JSON.Object<JSON.String, Value>();
        for (String key : valueCollector.keySet()) {
            marshaledObject.put(new JSON.String(key), (Value)valueCollector.get(key));
        }
        return marshaledObject;
    }

    protected Value marshalObjectMethodValue(Method method, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Value value = null;
        Object marshaledObject = method.invoke(o, new Object[0]);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (marshaledObject.getClass() == Boolean.class || marshaledObject.getClass() == Short.class || marshaledObject.getClass() == Integer.class || marshaledObject.getClass() == Float.class || marshaledObject.getClass() == Double.class || marshaledObject.getClass() == Long.class || marshaledObject.getClass() == String.class) {
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else if (!cycleDetector.hashDetected(hashCode) || cycleDetector.getHashCount(hashCode) < JavaObjectMarshaler.getCycleLevels()) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }

    protected Value marshalObjectFieldValue(Field field, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalArgumentException, IllegalAccessException {
        Value value = null;
        Object marshaledObject = field.get(o);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (marshaledObject.getClass() == Boolean.class || marshaledObject.getClass() == Short.class || marshaledObject.getClass() == Integer.class || marshaledObject.getClass() == Float.class || marshaledObject.getClass() == Double.class || marshaledObject.getClass() == Long.class || marshaledObject.getClass() == String.class) {
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else if (!cycleDetector.hashDetected(hashCode) || cycleDetector.getHashCount(hashCode) < JavaObjectMarshaler.getCycleLevels()) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }

    public static boolean hasCodec(Class codecType) {
        if (codecStore == null) {
            return false;
        }
        return codecStore.hasCodec(codecType);
    }

    public static void registerCodec(Class<?> codecClass) {
        if (codecStore == null) {
            codecStore = new JSONCodecStore();
        }
        codecStore.registerCodec(codecClass);
    }

    public static JSONCodec<?> getCodec(Class codecType) {
        if (codecStore == null) {
            return null;
        }
        return codecStore.getCodec(codecType);
    }

    public static int getCycleLevels() {
        return cycleLevels;
    }

    public static void setCycleLevels(int levels) {
        cycleLevels = levels;
    }

    static {
        cycleLevels = 0;
    }
}

