/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.marshal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jsonij.json.JSON;
import jsonij.json.Value;
import jsonij.json.marshal.JavaObjectMarshaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMarshaler {
    JavaObjectMarshaler javaObjectMarshaler = new JavaObjectMarshaler(this);

    public Value marshalObject(Object o) {
        CycleDetector cycleDetector = new CycleDetector();
        return this.marshalAnyObject(o, cycleDetector);
    }

    public Value marshalObject(boolean[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Boolean> marshaledArray = new JSON.Array<JSON.Boolean>();
        for (int i = 0; i < size; ++i) {
            if (a[i]) {
                marshaledArray.add(JSON.TRUE);
                continue;
            }
            marshaledArray.add(JSON.FALSE);
        }
        return marshaledArray;
    }

    public Value marshalObject(Boolean[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Boolean> marshaledArray = new JSON.Array<JSON.Boolean>();
        for (int i = 0; i < size; ++i) {
            if (a[i].booleanValue()) {
                marshaledArray.add(JSON.TRUE);
                continue;
            }
            marshaledArray.add(JSON.FALSE);
        }
        return marshaledArray;
    }

    public Value marshalObject(int[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Integer[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(char[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.String> marshaledArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.String("" + a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Character[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.String> marshaledArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.String("" + a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(double[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Double[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(float[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Float[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(short[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Short[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(long[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Long[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.Numeric> marshaledArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.Numeric(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(String[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        JSON.Array<JSON.String> marshaledArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            marshaledArray.add(new JSON.String(a[i]));
        }
        return marshaledArray;
    }

    public Value marshalObject(Object[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON.Array();
        }
        CycleDetector cycleDetector = new CycleDetector();
        JSON.Array<Value> marshaledArray = new JSON.Array<Value>();
        for (int i = 0; i < size; ++i) {
            Value marshaledObject = this.marshalJavaObject(a[i], cycleDetector);
            if (marshaledObject != null) {
                marshaledArray.add(marshaledObject);
                continue;
            }
            marshaledArray.add(JSON.NULL);
        }
        return marshaledArray;
    }

    protected TYPE inspectObjectType(Class<?> c) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            return TYPE.BOOLEAN;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return TYPE.NUMERIC;
        }
        if (c == Double.TYPE || c == Double.class) {
            return TYPE.NUMERIC;
        }
        if (c == Float.TYPE || c == Float.class) {
            return TYPE.NUMERIC;
        }
        if (c == Long.TYPE || c == Long.class) {
            return TYPE.NUMERIC;
        }
        if (c == Short.TYPE || c == Short.class) {
            return TYPE.NUMERIC;
        }
        if (c.isEnum()) {
            return TYPE.ENUM;
        }
        if (c == String.class || c == Character.TYPE || c == Character.class) {
            return TYPE.STRING;
        }
        if (c.isArray()) {
            return TYPE.ARRAY;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < Array.getLength(interfaces); ++i) {
            if (interfaces[i] != List.class) continue;
            return TYPE.LIST;
        }
        if (this.javaObjectMarshaler.isObjectType(c)) {
            return TYPE.OBJECT;
        }
        Class<?> parent = c.getSuperclass();
        if (parent != null) {
            do {
                interfaces = parent.getInterfaces();
                for (int i = 0; i < Array.getLength(interfaces); ++i) {
                    if (interfaces[i] != List.class) continue;
                    return TYPE.LIST;
                }
            } while ((parent = parent.getSuperclass()) != null);
        }
        return TYPE.UNKOWN;
    }

    protected Value marshalAnyObject(Object o, CycleDetector cycleDetector) {
        if (o == null) {
            return JSON.NULL;
        }
        Value marshaledObject = null;
        Class<?> objectClass = o.getClass();
        TYPE objectType = this.inspectObjectType(objectClass);
        switch (objectType) {
            case BOOLEAN: {
                marshaledObject = this.marshalJavaBoolean(o);
                break;
            }
            case NUMERIC: {
                marshaledObject = this.marshalJavaNumeric(o);
                break;
            }
            case STRING: {
                marshaledObject = this.marshalJavaString(o);
                break;
            }
            case ENUM: {
                marshaledObject = this.marshalJavaEnum(o);
                break;
            }
            case ARRAY: {
                marshaledObject = this.marshalJavaArray(o, cycleDetector);
                break;
            }
            case LIST: {
                marshaledObject = this.marshalJavaList(o, cycleDetector);
                break;
            }
            case OBJECT: {
                marshaledObject = this.marshalJavaObject(o, cycleDetector);
                break;
            }
            case MAP: {
                marshaledObject = this.marshalJavaMap(o, cycleDetector);
                break;
            }
            case UNKOWN: {
                marshaledObject = new JSON.String(o.getClass().getCanonicalName() + "@" + Integer.toHexString(o.hashCode()));
            }
        }
        return marshaledObject;
    }

    protected Value marshalJavaBoolean(Object o) {
        JSON.Boolean value = null;
        boolean marshaledBoolean = (Boolean)o;
        value = marshaledBoolean ? JSON.TRUE : JSON.FALSE;
        return value;
    }

    protected Value marshalJavaNumeric(Object o) {
        Value value = null;
        Number marshaledNumber = null;
        marshaledNumber = (Number)o;
        value = marshaledNumber != null ? new JSON.Numeric(marshaledNumber) : JSON.NULL;
        return value;
    }

    protected Value marshalJavaEnum(Object o) {
        Value value = null;
        if (o != null) {
            String marshaledEnumeration = o.toString();
            value = new JSON.String(marshaledEnumeration);
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    protected Value marshalJavaString(Object o) {
        Value value = null;
        String marshaledString = (String)o;
        value = marshaledString != null ? new JSON.String(marshaledString) : JSON.NULL;
        return value;
    }

    protected Value marshalJavaArray(Object o, CycleDetector cycleDetector) {
        Value value = null;
        if (o != null) {
            JSON.Array<Value> marshaledArray = new JSON.Array<Value>();
            int size = Array.getLength(o);
            Class<?> type = o.getClass();
            Class<?> componentType = type.getComponentType();
            if (componentType == Integer.TYPE || componentType == Integer.class) {
                for (int i = 0; i < size; ++i) {
                    marshaledArray.add(new JSON.Numeric(Array.getInt(o, i)));
                }
            } else if (componentType == Double.TYPE || componentType == Double.class) {
                for (int i = 0; i < size; ++i) {
                    marshaledArray.add(new JSON.Numeric(Array.getDouble(o, i)));
                }
            } else if (componentType == Float.TYPE || componentType == Float.class) {
                for (int i = 0; i < size; ++i) {
                    marshaledArray.add(new JSON.Numeric(Array.getFloat(o, i)));
                }
            } else if (componentType == Short.TYPE || componentType == Short.class) {
                for (int i = 0; i < size; ++i) {
                    marshaledArray.add(new JSON.Numeric(Array.getShort(o, i)));
                }
            } else if (componentType == Long.TYPE || componentType == Long.class) {
                for (int i = 0; i < size; ++i) {
                    marshaledArray.add(new JSON.Numeric(Array.getLong(o, i)));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    Object arrayValue = Array.get(o, i);
                    marshaledArray.add(this.marshalAnyObject(arrayValue, cycleDetector.cloneCycleDetector()));
                }
            }
            value = marshaledArray;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    protected Value marshalJavaList(Object o, CycleDetector cycleDetector) {
        Value value = null;
        List marshaledList = (List)o;
        if (marshaledList != null) {
            JSON.Array<Value> marshaledArray = new JSON.Array<Value>();
            ListIterator marshaledListIterator = marshaledList.listIterator();
            Object listItem = null;
            while (marshaledListIterator.hasNext()) {
                listItem = marshaledListIterator.next();
                if (listItem == null) {
                    marshaledArray.add(JSON.NULL);
                    continue;
                }
                marshaledArray.add(this.marshalAnyObject(listItem, cycleDetector.cloneCycleDetector()));
            }
            value = marshaledArray;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    protected Value marshalJavaMap(Object o, CycleDetector cycleDetector) {
        Value value = null;
        Map marshaledMap = (Map)o;
        if (marshaledMap != null) {
            JSON.Object<JSON.String, Value> marshaledObject = new JSON.Object<JSON.String, Value>();
            for (Object keyObject : marshaledMap.keySet()) {
                Object valueObject = marshaledMap.get(keyObject);
                marshaledObject.put(new JSON.String(keyObject.toString()), this.marshalAnyObject(valueObject, cycleDetector.cloneCycleDetector()));
            }
            value = marshaledObject;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    protected Value marshalJavaObject(Object o, CycleDetector cycleDetector) {
        Value marshaledValue = this.javaObjectMarshaler.marshalJavaObject(o, cycleDetector);
        return marshaledValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CycleDetector
    implements Cloneable {
        final HashMap<Integer, Integer> list;

        public CycleDetector() {
            this.list = new HashMap();
        }

        protected CycleDetector(HashMap<Integer, Integer> list) {
            this.list = list;
        }

        public boolean hashDetected(int hash) {
            return this.list.containsKey(hash);
        }

        public int getHashCount(int hash) {
            if (this.list.containsKey(hash)) {
                return this.list.get(hash);
            }
            return 0;
        }

        public void addHash(int hash) {
            if (!this.hashDetected(hash)) {
                this.list.put(hash, 0);
            } else {
                Integer value = this.list.remove(hash);
                value = value + 1;
                this.list.put(hash, value);
            }
        }

        protected CycleDetector cloneCycleDetector() {
            HashMap<Integer, Integer> newHashMap = new HashMap<Integer, Integer>();
            for (Integer key : this.list.keySet()) {
                Integer value = this.list.get(key);
                newHashMap.put(key, value);
            }
            return new CycleDetector(newHashMap);
        }

        protected Object clone() throws CloneNotSupportedException {
            return new CycleDetector((HashMap)this.list.clone());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        BOOLEAN,
        NUMERIC,
        STRING,
        ARRAY,
        LIST,
        OBJECT,
        MAP,
        ENUM,
        UNKOWN;

    }
}

