/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import jsonij.parser.BaseParserException;

public abstract class ParserException
extends BaseParserException {
    protected String key;
    protected Locale locale;

    public ParserException(String key, Object ... args) {
        this(key, -1, -1, null, args);
    }

    public ParserException(String key, int line, int position, Object ... args) {
        this(key, line, position, null, args);
    }

    public ParserException(String key, int line, int position, Locale locale, Object ... args) {
        this.line = line;
        this.position = position;
        this.key = key;
        Locale locale2 = this.locale = locale == null ? Locale.ENGLISH : locale;
        if (this.locale != null) {
            String messageFormat = ResourceBundle.getBundle(this.getBundleName()).getString(this.key);
            this.message = String.format(messageFormat, args);
        } else {
            this.message = String.format("Undefined Exception %s %s", key, locale);
        }
    }

    public abstract String getBundleName();
}

