/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsonij.json.ConstantUtility;
import jsonij.json.Constants;
import jsonij.json.JSON;
import jsonij.json.JSONParserException;
import jsonij.json.JSONReader;
import jsonij.json.Value;
import jsonij.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONParser {
    protected static final Logger logger = Logger.getLogger(JSONParser.class.getName());
    protected Locale locale = Locale.ENGLISH;

    public Locale getLocale() {
        return this.locale;
    }

    public Locale setLocale(Locale locale) {
        this.locale = locale;
        return this.locale;
    }

    public Value parse(String target) throws IOException, ParserException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "parse(String target)", target);
        }
        Value value = null;
        ByteArrayInputStream targetArrayStream = new ByteArrayInputStream(target.getBytes());
        InputStreamReader targetReader = new InputStreamReader(targetArrayStream);
        value = this.parse(targetReader);
        targetReader.close();
        targetArrayStream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "parse(String target)", value);
        }
        return value;
    }

    public synchronized Value parse(Reader targetReader) throws IOException, ParserException {
        String method = "parse(JSONReader targetReader)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, targetReader);
        }
        if (targetReader == null) {
            throw new NullPointerException();
        }
        JSONReader target = new JSONReader(targetReader);
        int r = target.peek();
        if (r == -1) {
            throw new JSONParserException("invalidEmpty", new Object[0]);
        }
        Value value = null;
        if (r == 123) {
            value = this.parseObject(target);
        } else if (r == 91) {
            value = this.parseArray(target);
        } else {
            throw new JSONParserException("invalidExpecting2", 123, 91, new Object[]{Character.valueOf((char)r)});
        }
        if (target.peek() != -1) {
            // empty if block
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    public Value parseValue(String target) throws IOException, ParserException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "parse(String target)", target);
        }
        Value value = null;
        ByteArrayInputStream targetArrayStream = new ByteArrayInputStream(target.getBytes());
        InputStreamReader targetReader = new InputStreamReader(targetArrayStream);
        value = this.parseValue(new JSONReader(targetReader));
        targetReader.close();
        targetArrayStream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "parse(String target)", value);
        }
        return value;
    }

    protected Value parseValue(JSONReader target) throws IOException, ParserException {
        String method = "parseValue(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        Value value = null;
        if (target.peek() == 123) {
            value = this.parseObject(target);
        } else if (target.peek() == 91) {
            value = this.parseArray(target);
        } else if (target.peek() == 34) {
            value = this.parseString(target);
        } else if (ConstantUtility.isNumeric(target.peek())) {
            value = this.parseNumeric(target);
        } else if (target.peek() == "true".charAt(0)) {
            value = this.parseTrue(target);
        } else if (target.peek() == "false".charAt(0)) {
            value = this.parseFalse(target);
        } else if (target.peek() == "null".charAt(0)) {
            value = this.parseNull(target);
        } else {
            throw new JSONParserException("invalidUnexpected", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.Object<JSON.String, Value> parseObject(JSONReader target) throws IOException, ParserException {
        String method = "parseObject(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        if (target.peek() != 123) {
            throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('{'), Character.valueOf((char)target.peek())});
        }
        target.read();
        JSON.Object<JSON.String, Value> value = new JSON.Object<JSON.String, Value>();
        if (target.peek() != 125) {
            JSON.String attributeName = this.parseString(target);
            if (target.peek() != 58) {
                throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)target.peek())});
            }
            target.read();
            Value attributeValue = this.parseValue(target);
            value.put(attributeName, attributeValue);
            while (target.peek() == 44) {
                target.read();
                attributeName = this.parseString(target);
                if (target.peek() != 58) {
                    throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)target.peek())});
                }
                target.read();
                attributeValue = this.parseValue(target);
                value.put(attributeName, attributeValue);
            }
        }
        if (target.peek() != 125) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('}'), Character.valueOf((char)target.peek())});
        }
        target.read();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.Array<Value> parseArray(JSONReader target) throws IOException, ParserException {
        String method = "parseArray(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        if (target.peek() != 91) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)target.peek())});
        }
        target.read();
        JSON.Array<Value> value = new JSON.Array<Value>();
        if (target.peek() != 93) {
            Value arrayValue = this.parseValue(target);
            value.add(arrayValue);
            while (target.peek() == 44) {
                target.read();
                arrayValue = this.parseValue(target);
                value.add(arrayValue);
            }
        }
        if (target.peek() != 93) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        target.read();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.String parseString(JSONReader target) throws IOException, ParserException {
        String method = "parseString(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        JSON.String value = null;
        if (target.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)target.peek())});
        }
        String valueString = "";
        JSONReader.JSONStringReader targetString = target.getStringReader();
        targetString.read();
        while (targetString.peek() != 34) {
            if (targetString.peek() == 92) {
                targetString.read();
                switch (targetString.peek()) {
                    case 34: {
                        valueString = valueString + '\"';
                        targetString.read();
                        break;
                    }
                    case 92: {
                        valueString = valueString + '\\';
                        targetString.read();
                        break;
                    }
                    case 47: {
                        valueString = valueString + '/';
                        targetString.read();
                        break;
                    }
                    case 98: {
                        valueString = valueString + '\b';
                        targetString.read();
                        break;
                    }
                    case 102: {
                        valueString = valueString + '\f';
                        targetString.read();
                        break;
                    }
                    case 110: {
                        valueString = valueString + '\n';
                        targetString.read();
                        break;
                    }
                    case 114: {
                        valueString = valueString + '\r';
                        targetString.read();
                        break;
                    }
                    case 116: {
                        valueString = valueString + '\t';
                        targetString.read();
                        break;
                    }
                    case 117: {
                        targetString.read();
                        String unicodeString = "";
                        for (int i = 0; i < 4; ++i) {
                            if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                throw new JSONParserException("invalidStringHex", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                            }
                            unicodeString = unicodeString + (char)targetString.read();
                        }
                        int unicodeInt = Integer.parseInt(unicodeString.toUpperCase(), 16);
                        if (Character.isHighSurrogate((char)unicodeInt)) {
                            String highSurrogateString = unicodeString;
                            int highSurrogate = unicodeInt;
                            unicodeString = "";
                            if (targetString.peek() != 92) {
                                throw new JSONParserException("invalidStringMissingSurrogate", target.getLineNumber(), target.getPositionNumber(), new Object[]{92, targetString.peek()});
                            }
                            targetString.read();
                            if (targetString.peek() != 117) {
                                throw new JSONParserException("invalidStringMissingSurrogate", target.getLineNumber(), target.getPositionNumber(), new Object[]{117, targetString.peek()});
                            }
                            targetString.read();
                            for (int i = 0; i < 4; ++i) {
                                if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                    throw new JSONParserException("invalidStringHex", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                                }
                                unicodeString = unicodeString + (char)targetString.read();
                            }
                            String lowSurrogateString = unicodeString;
                            int lowSurrogate = Integer.parseInt(unicodeString.toUpperCase(), 16);
                            if (Character.isSurrogatePair((char)highSurrogate, (char)lowSurrogate)) {
                                valueString = valueString + new String(Character.toChars(Character.toCodePoint((char)highSurrogate, (char)lowSurrogate)));
                                break;
                            }
                            throw new JSONParserException("invalidStringSurrogates", target.getLineNumber(), target.getPositionNumber(), new Object[]{highSurrogateString, lowSurrogateString});
                        }
                        valueString = valueString + (char)unicodeInt;
                        break;
                    }
                    default: {
                        throw new JSONParserException("invalidStringEscape", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                    }
                }
                continue;
            }
            if (ConstantUtility.isValidStringChar(targetString.peek())) {
                valueString = valueString + (char)targetString.read();
                continue;
            }
            throw new JSONParserException("invalidStringValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)targetString.peek())});
        }
        if (targetString.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)targetString.peek())});
        }
        targetString.read();
        targetString.close();
        value = new JSON.String(valueString);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.Numeric parseNumeric(JSONReader target) throws IOException, ParserException {
        JSON.Numeric value = null;
        StringBuilder numericStringBuilder = new StringBuilder();
        boolean minusFlag = false;
        boolean decimalFlag = false;
        boolean exponetFlag = false;
        int beforeDecimalCount = 0;
        if (target.peek() == 45) {
            minusFlag = true;
            target.read();
            numericStringBuilder.append('-');
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
        }
        if (target.peek() == Constants.DIGITS[0]) {
            numericStringBuilder.append((char)target.read());
            ++beforeDecimalCount;
        } else if (target.peek() >= Constants.DIGITS[1] && target.peek() <= Constants.DIGITS[9]) {
            numericStringBuilder.append((char)target.read());
            ++beforeDecimalCount;
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
                ++beforeDecimalCount;
            }
        } else {
            throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 46) {
            target.read();
            decimalFlag = true;
            numericStringBuilder.append('.');
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
            }
        }
        if (target.peek() == Constants.EXPS[0] || target.peek() == Constants.EXPS[1]) {
            target.read();
            exponetFlag = true;
            numericStringBuilder.append(Constants.EXPS[1]);
            if (target.peek() == 45) {
                target.read();
                numericStringBuilder.append('-');
            } else if (target.peek() == 43) {
                target.read();
                numericStringBuilder.append('+');
            } else {
                numericStringBuilder.append('+');
            }
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
            }
        }
        value = !decimalFlag && !exponetFlag ? (beforeDecimalCount < 18 ? new JSON.Numeric(Long.parseLong(numericStringBuilder.toString())) : new JSON.Numeric(new BigInteger(numericStringBuilder.toString()))) : new JSON.Numeric(Double.parseDouble(numericStringBuilder.toString()));
        return value;
    }

    protected JSON.True parseTrue(JSONReader target) throws IOException, ParserException {
        String method = "parseTrue(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        JSON.True value = null;
        for (int i = 0; i < "true".length(); ++i) {
            if (target.peek() != "true".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"true", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.TRUE;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.False parseFalse(JSONReader target) throws IOException, ParserException {
        String method = "parseFalse(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        JSON.False value = null;
        for (int i = 0; i < "false".length(); ++i) {
            if (target.peek() != "false".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"false", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.FALSE;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }

    protected JSON.Null parseNull(JSONReader target) throws IOException, ParserException {
        String method = "parseNull(JSONReader target)";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), method, target);
        }
        JSON.Null value = null;
        for (int i = 0; i < "null".length(); ++i) {
            if (target.peek() != "null".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"null", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.NULL;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), method, value);
        }
        return value;
    }
}

