/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jsonij.json.annotation.JSONAccessor;
import jsonij.json.annotation.JSONIgnore;
import jsonij.json.annotation.JSONMutator;
import jsonij.json.annotation.JSONName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inspector {
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";
    Object o;
    Class<?> c;
    InspectorProperty[] properties;

    public Inspector(Class<?> c) {
        this.c = c;
        this.o = null;
        this.properties = null;
    }

    public Inspector(Object o) {
        this.o = o;
        this.properties = null;
    }

    public void inspect() {
        Field[] objectFields;
        Method[] objectMethods;
        if (this.o == null && this.c == null) {
            return;
        }
        if (this.o != null) {
            this.c = this.o.getClass();
        }
        Class<?> objectClass = this.c;
        ArrayList<InspectorProperty> propertiesList = new ArrayList<InspectorProperty>();
        InspectorProperty property = null;
        Class<?> type = null;
        String name = null;
        String accessName = null;
        String mutateName = null;
        for (Method method : objectMethods = objectClass.getMethods()) {
            char c;
            property = new InspectorProperty();
            property.setAccessType(InspectorProperty.TYPE.METHOD);
            boolean nameFlag = false;
            name = Inspector.getJSONName(method);
            if (name != null) {
                property.setName(name);
                property.setUnannotatedPropertyName(name);
                nameFlag = true;
            }
            if ((name = Inspector.getJSONAccessor(method)) != null) {
                property.setAccessor(true);
                property.setAccessName(method.getName());
                if (!nameFlag) {
                    property.setName(name);
                    property.setUnannotatedPropertyName(name);
                    nameFlag = true;
                }
            }
            if ((name = Inspector.getJSONMutator(method)) != null) {
                property.setMutator(true);
                property.setMutateName(method.getName());
                if (!nameFlag) {
                    property.setName(name);
                    property.setUnannotatedPropertyName(name);
                    nameFlag = true;
                }
            }
            type = method.getReturnType();
            name = method.getName();
            if (name.length() > IS_PREFIX.length() && name.startsWith(IS_PREFIX) && type == Boolean.TYPE && Character.isUpperCase(c = name.charAt(IS_PREFIX.length()))) {
                name = Character.toLowerCase(c) + name.substring(IS_PREFIX.length() + 1, name.length());
                if (!nameFlag) {
                    property.setName(name);
                }
                property.setAccessName(method.getName());
                property.setUnannotatedPropertyName(name);
                property.setAccessor(true);
            } else if (name.length() > SET_PREFIX.length() && name.startsWith(SET_PREFIX) && Character.isUpperCase(c = name.charAt(SET_PREFIX.length()))) {
                name = Character.toLowerCase(c) + name.substring(SET_PREFIX.length() + 1, name.length());
                if (!nameFlag) {
                    property.setName(name);
                }
                property.setMutateName(method.getName());
                property.setUnannotatedPropertyName(name);
                property.setMutator(true);
            } else if (name.length() > GET_PREFIX.length() && name.startsWith(GET_PREFIX) && Character.isUpperCase(c = name.charAt(GET_PREFIX.length())) && type != null) {
                name = Character.toLowerCase(c) + name.substring(GET_PREFIX.length() + 1, name.length());
                if (!nameFlag) {
                    property.setName(name);
                }
                property.setAccessName(method.getName());
                property.setUnannotatedPropertyName(name);
                property.setAccessor(true);
            }
            if (this.isJSONIgnored(method)) {
                property.setIgnore(true);
            }
            if (property.getName() == null) continue;
            boolean found = false;
            for (InspectorProperty prop : propertiesList) {
                if (!property.getName().equals(prop.getName())) continue;
                if (property.isAccessor() && property.getAccessName() != null) {
                    prop.setAccessor(true);
                    prop.setAccessName(property.getAccessName());
                    found = true;
                    break;
                }
                if (!property.isMutator() || property.getMutateName() == null) continue;
                prop.setMutator(true);
                prop.setMutateName(property.getMutateName());
                found = true;
                break;
            }
            if (found) continue;
            propertiesList.add(property);
        }
        for (Field field : objectFields = objectClass.getFields()) {
            name = Inspector.getJSONName(field);
            if (name == null) {
                name = field.getName();
            }
            mutateName = accessName = field.getName();
            boolean found = false;
            for (InspectorProperty prop : propertiesList) {
                if (!prop.hasAccessorAndMutator() || !name.equals(prop.getName()) && !accessName.equals(prop.getUnannotatedPropertyName()) && !accessName.equals(prop.getAccessName())) continue;
                if (this.isJSONIgnored(field)) {
                    prop.setIgnore(true);
                }
                if (!name.equals(accessName)) {
                    prop.setName(name);
                }
                found = true;
            }
            if (found) continue;
            property = new InspectorProperty();
            property.setName(name);
            property.setAccessType(InspectorProperty.TYPE.FIELD);
            property.setAccessName(accessName);
            property.setMutateName(mutateName);
            property.setUnannotatedPropertyName(accessName);
            if (this.isJSONIgnored(field)) {
                property.setIgnore(true);
            }
            propertiesList.add(property);
        }
        this.properties = new InspectorProperty[propertiesList.size()];
        this.properties = propertiesList.toArray(this.properties);
    }

    public Object getO() {
        return this.o;
    }

    public void setO(Object o) {
        this.o = o;
        this.properties = null;
    }

    public InspectorProperty[] getProperties() {
        if (this.o != null && this.properties == null) {
            this.inspect();
        }
        return this.properties;
    }

    public void setProperties(InspectorProperty[] properties) {
        this.properties = properties;
    }

    public boolean isJSONIgnored(AccessibleObject object) {
        return object.getAnnotation(JSONIgnore.class) != null;
    }

    public static String getAnnotatedName(AccessibleObject object) {
        String name = Inspector.getJSONName(object);
        if (name == null) {
            name = Inspector.getJSONMutator(object);
        }
        if (name == null) {
            name = Inspector.getJSONAccessor(object);
        }
        return name;
    }

    public static String getJSONName(AccessibleObject object) {
        String name = null;
        JSONName jsonNameAnnotation = object.getAnnotation(JSONName.class);
        if (jsonNameAnnotation != null) {
            name = jsonNameAnnotation.value();
        }
        return name;
    }

    public static String getJSONMutator(AccessibleObject object) {
        String name = null;
        JSONMutator jsonMutatorAnnotation = object.getAnnotation(JSONMutator.class);
        if (jsonMutatorAnnotation != null) {
            name = jsonMutatorAnnotation.value();
        }
        return name;
    }

    public static String getJSONAccessor(AccessibleObject object) {
        String name = null;
        JSONAccessor jsonAccessorAnnotation = object.getAnnotation(JSONAccessor.class);
        if (jsonAccessorAnnotation != null) {
            name = jsonAccessorAnnotation.value();
        }
        return name;
    }

    public static class InspectorProperty {
        public String name;
        public TYPE accessType;
        public String accessName;
        public String mutateName;
        public String unannotatedPropertyName;
        public boolean ignore;
        public boolean accessor;
        public boolean mutator;

        public InspectorProperty() {
            this.name = null;
            this.accessType = null;
            this.accessName = null;
            this.mutateName = null;
            this.unannotatedPropertyName = null;
            this.ignore = false;
            this.accessor = false;
            this.mutator = false;
        }

        public InspectorProperty(String name, TYPE accessType) {
            this.name = name;
            this.accessType = accessType;
            this.accessName = null;
            this.unannotatedPropertyName = null;
            this.ignore = false;
            this.accessor = false;
            this.mutator = false;
        }

        public TYPE getAccessType() {
            return this.accessType;
        }

        public void setAccessType(TYPE accessType) {
            this.accessType = accessType;
        }

        public String getAccessName() {
            return this.accessName;
        }

        public void setAccessName(String accessName) {
            this.accessName = accessName;
        }

        public String getMutateName() {
            return this.mutateName;
        }

        public void setMutateName(String mutateName) {
            this.mutateName = mutateName;
        }

        public String getUnannotatedPropertyName() {
            return this.unannotatedPropertyName;
        }

        public void setUnannotatedPropertyName(String unannotatedPropertyName) {
            this.unannotatedPropertyName = unannotatedPropertyName;
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        public boolean isAccessor() {
            return this.accessor;
        }

        public void setAccessor(boolean accessor) {
            this.accessor = accessor;
        }

        public boolean isMutator() {
            return this.mutator;
        }

        public void setMutator(boolean mutator) {
            this.mutator = mutator;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean hasAccessorAndMutator() {
            return this.accessType == TYPE.FIELD || this.mutator && this.accessor;
        }

        public boolean isValid() {
            return this.name != null && this.hasAccessorAndMutator();
        }

        public String toString() {
            return String.format("ObjectProperty %s%s (%s) valid:\"%s\" unannotated:\"%s\" (>\"%s\" <\"%s\")", new Object[]{this.ignore ? "-" : "+", this.name, this.accessType, this.hasAccessorAndMutator(), this.unannotatedPropertyName, this.mutateName, this.accessName});
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            FIELD,
            METHOD;

        }
    }
}

