/**
 * 	The MIT License (MIT)

	Copyright (c) 2016-2016 d3leaf@126.com

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.
 */
package cc.ecore.spring.jfinal.javassist;

/**
 * Javassist 工厂
 */
public class CtFactory {

	public static void toClass() {
		try {
			Class.forName("javassist.ClassPool");
		} catch (ClassNotFoundException e) {
			throw new RuntimeException("javassist no import.");
		}
		try {
			if (!isToClass()) {
				synchronized (CtFactory.class) {
					if (!isToClass()) {
						new JFinalCtClass("com.jfinal.core.JFinal").getCtClass().toClass();
						new ControllerCtClass("com.jfinal.core.Controller").getCtClass().toClass();
						new ActionHandlerCtClass("com.jfinal.core.ActionHandler").getCtClass().toClass();
						new JFinalFilterCtClass("com.jfinal.core.JFinalFilter").getCtClass().toClass();
						System.setProperty("isToClass", "true");
					}
				}
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	static boolean isToClass() {
		String isToClass = System.getProperty("isToClass");
		return (isToClass == null || isToClass.trim().isEmpty() || isToClass.equals("false")) ? false : true;
	}
}
