/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class VAR
extends AbstractSegment {
    public VAR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Variance Instance ID");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Documented Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Stated Variance Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Variance Originator");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Variance Classification");
            this.add(ST.class, false, 0, 512, new Object[]{this.getMessage()}, "Variance Description");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VAR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getVarianceInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getVar1_VarianceInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getDocumentedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getVar2_DocumentedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getStatedVarianceDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getVar3_StatedVarianceDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN[] getVarianceOriginator() {
        XCN[] retVal = (XCN[])this.getTypedField(4, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getVar4_VarianceOriginator() {
        XCN[] retVal = (XCN[])this.getTypedField(4, (Type[])new XCN[0]);
        return retVal;
    }

    public int getVarianceOriginatorReps() {
        return this.getReps(4);
    }

    public XCN getVarianceOriginator(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getVar4_VarianceOriginator(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getVar4_VarianceOriginatorReps() {
        return this.getReps(4);
    }

    public XCN insertVarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertVar4_VarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removeVarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removeVar4_VarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public CWE getVarianceClassification() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getVar5_VarianceClassification() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public ST[] getVarianceDescription() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getVar6_VarianceDescription() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public int getVarianceDescriptionReps() {
        return this.getReps(6);
    }

    public ST getVarianceDescription(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getVar6_VarianceDescription(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getVar6_VarianceDescriptionReps() {
        return this.getReps(6);
    }

    public ST insertVarianceDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertVar6_VarianceDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeVarianceDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeVar6_VarianceDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

