/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class URD
extends AbstractSegment {
    public URD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "R/U Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(109)}, "Report Priority");
            this.add(XCN.class, true, 0, 250, new Object[]{this.getMessage()}, "R/U Who Subject Definition");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "R/U What Subject Definition");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "R/U What Department Code");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U Display/Print Locations");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "R/U Results Level");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating URD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public DTM getRUDateTime() {
        DTM retVal = (DTM)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getUrd1_RUDateTime() {
        DTM retVal = (DTM)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getUrd2_ReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getRUWhoSubjectDefinition() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getUrd3_RUWhoSubjectDefinition() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public int getRUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public XCN getRUWhoSubjectDefinition(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getUrd3_RUWhoSubjectDefinition(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getUrd3_RUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public XCN insertRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removeRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public CWE[] getRUWhatSubjectDefinition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getUrd4_RUWhatSubjectDefinition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getRUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public CWE getRUWhatSubjectDefinition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getUrd4_RUWhatSubjectDefinition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getUrd4_RUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public CWE insertRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE[] getRUWhatDepartmentCode() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getUrd5_RUWhatDepartmentCode() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public int getRUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public CWE getRUWhatDepartmentCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getUrd5_RUWhatDepartmentCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getUrd5_RUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public CWE insertRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public ST[] getRUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUrd6_RUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, (Type[])new ST[0]);
        return retVal;
    }

    public int getRUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST getRUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getUrd6_RUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUrd6_RUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST insertRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ID getRUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getUrd7_RUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new DTM(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(109));
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

