/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.AUI;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.NULLDT;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN1
extends AbstractSegment {
    public IN1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - IN1");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Insurance Plan ID");
            this.add(CX.class, true, 0, 250, new Object[]{this.getMessage()}, "Insurance Company ID");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Insurance Company Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Insurance Company Address");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Insurance Co Contact Person");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Insurance Co Phone Number");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Group Number");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Group Name");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Insured's Group Emp ID");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Insured's Group Emp Name");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan Expiration Date");
            this.add(AUI.class, false, 1, 239, new Object[]{this.getMessage()}, "Authorization Information");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(86)}, "Plan Type");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Name Of Insured");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Insured's Relationship To Patient");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Insured's Date Of Birth");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Insured's Address");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(135)}, "Assignment Of Benefits");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(173)}, "Coordination Of Benefits");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Coord Of Ben. Priority");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Notice Of Admission Flag");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Notice Of Admission Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Report Of Eligibility Flag");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Report Of Eligibility Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(93)}, "Release Information Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Pre-Admit Cert (PAC)");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Verification Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Verification By");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(98)}, "Type Of Agreement Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(22)}, "Billing Status");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Lifetime Reserve Days");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Delay Before L.R. Day");
            this.add(IS.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(42)}, "Company Plan Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Policy Number");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Policy Deductible");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Policy Limit - Amount");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Policy Limit - Days");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Room Rate - Semi-Private");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Room Rate - Private");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Insured's Employment Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Insured's Administrative Sex");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Insured's Employer's Address");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Verification Status");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "Prior Insurance Plan ID");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(309)}, "Coverage Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(295)}, "Handicap");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Insured's ID Number");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(535)}, "Signature Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Signature Code Date");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Insured's Birth Place");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP Indicator");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IN1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDIN1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn11_SetIDIN1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getInsurancePlanID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIn12_InsurancePlanID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CX[] getInsuranceCompanyID() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getIn13_InsuranceCompanyID() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public int getInsuranceCompanyIDReps() {
        return this.getReps(3);
    }

    public CX getInsuranceCompanyID(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public CX getIn13_InsuranceCompanyID(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getIn13_InsuranceCompanyIDReps() {
        return this.getReps(3);
    }

    public CX insertInsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertIn13_InsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removeInsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removeIn13_InsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public XON[] getInsuranceCompanyName() {
        XON[] retVal = (XON[])this.getTypedField(4, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getIn14_InsuranceCompanyName() {
        XON[] retVal = (XON[])this.getTypedField(4, (Type[])new XON[0]);
        return retVal;
    }

    public int getInsuranceCompanyNameReps() {
        return this.getReps(4);
    }

    public XON getInsuranceCompanyName(int rep) {
        XON retVal = (XON)this.getTypedField(4, rep);
        return retVal;
    }

    public XON getIn14_InsuranceCompanyName(int rep) {
        XON retVal = (XON)this.getTypedField(4, rep);
        return retVal;
    }

    public int getIn14_InsuranceCompanyNameReps() {
        return this.getReps(4);
    }

    public XON insertInsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON insertIn14_InsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON removeInsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XON removeIn14_InsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XAD[] getInsuranceCompanyAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getIn15_InsuranceCompanyAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, (Type[])new XAD[0]);
        return retVal;
    }

    public int getInsuranceCompanyAddressReps() {
        return this.getReps(5);
    }

    public XAD getInsuranceCompanyAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public XAD getIn15_InsuranceCompanyAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getIn15_InsuranceCompanyAddressReps() {
        return this.getReps(5);
    }

    public XAD insertInsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD insertIn15_InsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD removeInsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XAD removeIn15_InsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XPN[] getInsuranceCoContactPerson() {
        XPN[] retVal = (XPN[])this.getTypedField(6, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getIn16_InsuranceCoContactPerson() {
        XPN[] retVal = (XPN[])this.getTypedField(6, (Type[])new XPN[0]);
        return retVal;
    }

    public int getInsuranceCoContactPersonReps() {
        return this.getReps(6);
    }

    public XPN getInsuranceCoContactPerson(int rep) {
        XPN retVal = (XPN)this.getTypedField(6, rep);
        return retVal;
    }

    public XPN getIn16_InsuranceCoContactPerson(int rep) {
        XPN retVal = (XPN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getIn16_InsuranceCoContactPersonReps() {
        return this.getReps(6);
    }

    public XPN insertInsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN insertIn16_InsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN removeInsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XPN removeIn16_InsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XTN[] getInsuranceCoPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(7, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getIn17_InsuranceCoPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(7, (Type[])new XTN[0]);
        return retVal;
    }

    public int getInsuranceCoPhoneNumberReps() {
        return this.getReps(7);
    }

    public XTN getInsuranceCoPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public XTN getIn17_InsuranceCoPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getIn17_InsuranceCoPhoneNumberReps() {
        return this.getReps(7);
    }

    public XTN insertInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN insertIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN removeInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public XTN removeIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public ST getGroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIn18_GroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public XON[] getGroupName() {
        XON[] retVal = (XON[])this.getTypedField(9, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getIn19_GroupName() {
        XON[] retVal = (XON[])this.getTypedField(9, (Type[])new XON[0]);
        return retVal;
    }

    public int getGroupNameReps() {
        return this.getReps(9);
    }

    public XON getGroupName(int rep) {
        XON retVal = (XON)this.getTypedField(9, rep);
        return retVal;
    }

    public XON getIn19_GroupName(int rep) {
        XON retVal = (XON)this.getTypedField(9, rep);
        return retVal;
    }

    public int getIn19_GroupNameReps() {
        return this.getReps(9);
    }

    public XON insertGroupName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(9, rep);
    }

    public XON insertIn19_GroupName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(9, rep);
    }

    public XON removeGroupName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(9, rep);
    }

    public XON removeIn19_GroupName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(9, rep);
    }

    public CX[] getInsuredSGroupEmpID() {
        CX[] retVal = (CX[])this.getTypedField(10, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getIn110_InsuredSGroupEmpID() {
        CX[] retVal = (CX[])this.getTypedField(10, (Type[])new CX[0]);
        return retVal;
    }

    public int getInsuredSGroupEmpIDReps() {
        return this.getReps(10);
    }

    public CX getInsuredSGroupEmpID(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public CX getIn110_InsuredSGroupEmpID(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public int getIn110_InsuredSGroupEmpIDReps() {
        return this.getReps(10);
    }

    public CX insertInsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX insertIn110_InsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX removeInsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CX removeIn110_InsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public XON[] getInsuredSGroupEmpName() {
        XON[] retVal = (XON[])this.getTypedField(11, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getIn111_InsuredSGroupEmpName() {
        XON[] retVal = (XON[])this.getTypedField(11, (Type[])new XON[0]);
        return retVal;
    }

    public int getInsuredSGroupEmpNameReps() {
        return this.getReps(11);
    }

    public XON getInsuredSGroupEmpName(int rep) {
        XON retVal = (XON)this.getTypedField(11, rep);
        return retVal;
    }

    public XON getIn111_InsuredSGroupEmpName(int rep) {
        XON retVal = (XON)this.getTypedField(11, rep);
        return retVal;
    }

    public int getIn111_InsuredSGroupEmpNameReps() {
        return this.getReps(11);
    }

    public XON insertInsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(11, rep);
    }

    public XON insertIn111_InsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(11, rep);
    }

    public XON removeInsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(11, rep);
    }

    public XON removeIn111_InsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(11, rep);
    }

    public DT getPlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getIn112_PlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getPlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getIn113_PlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public AUI getAuthorizationInformation() {
        AUI retVal = (AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public AUI getIn114_AuthorizationInformation() {
        AUI retVal = (AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public IS getPlanType() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public IS getIn115_PlanType() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public XPN[] getNameOfInsured() {
        XPN[] retVal = (XPN[])this.getTypedField(16, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getIn116_NameOfInsured() {
        XPN[] retVal = (XPN[])this.getTypedField(16, (Type[])new XPN[0]);
        return retVal;
    }

    public int getNameOfInsuredReps() {
        return this.getReps(16);
    }

    public XPN getNameOfInsured(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public XPN getIn116_NameOfInsured(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getIn116_NameOfInsuredReps() {
        return this.getReps(16);
    }

    public XPN insertNameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN insertIn116_NameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN removeNameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XPN removeIn116_NameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public CWE getInsuredSRelationshipToPatient() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getIn117_InsuredSRelationshipToPatient() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getInsuredSDateOfBirth() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getIn118_InsuredSDateOfBirth() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public XAD[] getInsuredSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(19, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getIn119_InsuredSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(19, (Type[])new XAD[0]);
        return retVal;
    }

    public int getInsuredSAddressReps() {
        return this.getReps(19);
    }

    public XAD getInsuredSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(19, rep);
        return retVal;
    }

    public XAD getIn119_InsuredSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(19, rep);
        return retVal;
    }

    public int getIn119_InsuredSAddressReps() {
        return this.getReps(19);
    }

    public XAD insertInsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(19, rep);
    }

    public XAD insertIn119_InsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(19, rep);
    }

    public XAD removeInsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(19, rep);
    }

    public XAD removeIn119_InsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(19, rep);
    }

    public IS getAssignmentOfBenefits() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getIn120_AssignmentOfBenefits() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getCoordinationOfBenefits() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getIn121_CoordinationOfBenefits() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getCoordOfBenPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getIn122_CoordOfBenPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getNoticeOfAdmissionFlag() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getIn123_NoticeOfAdmissionFlag() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public DT getNoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getIn124_NoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getReportOfEligibilityFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getIn125_ReportOfEligibilityFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getReportOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getIn126_ReportOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public IS getReleaseInformationCode() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public IS getIn127_ReleaseInformationCode() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getPreAdmitCert() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public ST getIn128_PreAdmitCert() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public DTM getVerificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public DTM getIn129_VerificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public XCN[] getVerificationBy() {
        XCN[] retVal = (XCN[])this.getTypedField(30, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getIn130_VerificationBy() {
        XCN[] retVal = (XCN[])this.getTypedField(30, (Type[])new XCN[0]);
        return retVal;
    }

    public int getVerificationByReps() {
        return this.getReps(30);
    }

    public XCN getVerificationBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(30, rep);
        return retVal;
    }

    public XCN getIn130_VerificationBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(30, rep);
        return retVal;
    }

    public int getIn130_VerificationByReps() {
        return this.getReps(30);
    }

    public XCN insertVerificationBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(30, rep);
    }

    public XCN insertIn130_VerificationBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(30, rep);
    }

    public XCN removeVerificationBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(30, rep);
    }

    public XCN removeIn130_VerificationBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(30, rep);
    }

    public IS getTypeOfAgreementCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getIn131_TypeOfAgreementCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getBillingStatus() {
        IS retVal = (IS)this.getTypedField(32, 0);
        return retVal;
    }

    public IS getIn132_BillingStatus() {
        IS retVal = (IS)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getIn133_LifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getDelayBeforeLRDay() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public NM getIn134_DelayBeforeLRDay() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getCompanyPlanCode() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getIn135_CompanyPlanCode() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public ST getPolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getIn136_PolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public CP getPolicyDeductible() {
        CP retVal = (CP)this.getTypedField(37, 0);
        return retVal;
    }

    public CP getIn137_PolicyDeductible() {
        CP retVal = (CP)this.getTypedField(37, 0);
        return retVal;
    }

    public NULLDT getPolicyLimitAmount() {
        NULLDT retVal = (NULLDT)this.getTypedField(38, 0);
        return retVal;
    }

    public NULLDT getIn138_PolicyLimitAmount() {
        NULLDT retVal = (NULLDT)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getPolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getIn139_PolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NULLDT getRoomRateSemiPrivate() {
        NULLDT retVal = (NULLDT)this.getTypedField(40, 0);
        return retVal;
    }

    public NULLDT getIn140_RoomRateSemiPrivate() {
        NULLDT retVal = (NULLDT)this.getTypedField(40, 0);
        return retVal;
    }

    public NULLDT getRoomRatePrivate() {
        NULLDT retVal = (NULLDT)this.getTypedField(41, 0);
        return retVal;
    }

    public NULLDT getIn141_RoomRatePrivate() {
        NULLDT retVal = (NULLDT)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE getInsuredSEmploymentStatus() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE getIn142_InsuredSEmploymentStatus() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public IS getInsuredSAdministrativeSex() {
        IS retVal = (IS)this.getTypedField(43, 0);
        return retVal;
    }

    public IS getIn143_InsuredSAdministrativeSex() {
        IS retVal = (IS)this.getTypedField(43, 0);
        return retVal;
    }

    public XAD[] getInsuredSEmployerSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(44, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getIn144_InsuredSEmployerSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(44, (Type[])new XAD[0]);
        return retVal;
    }

    public int getInsuredSEmployerSAddressReps() {
        return this.getReps(44);
    }

    public XAD getInsuredSEmployerSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(44, rep);
        return retVal;
    }

    public XAD getIn144_InsuredSEmployerSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(44, rep);
        return retVal;
    }

    public int getIn144_InsuredSEmployerSAddressReps() {
        return this.getReps(44);
    }

    public XAD insertInsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(44, rep);
    }

    public XAD insertIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(44, rep);
    }

    public XAD removeInsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(44, rep);
    }

    public XAD removeIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(44, rep);
    }

    public ST getVerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public ST getIn145_VerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public IS getPriorInsurancePlanID() {
        IS retVal = (IS)this.getTypedField(46, 0);
        return retVal;
    }

    public IS getIn146_PriorInsurancePlanID() {
        IS retVal = (IS)this.getTypedField(46, 0);
        return retVal;
    }

    public IS getCoverageType() {
        IS retVal = (IS)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getIn147_CoverageType() {
        IS retVal = (IS)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public IS getIn148_Handicap() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public CX[] getInsuredSIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(49, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getIn149_InsuredSIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(49, (Type[])new CX[0]);
        return retVal;
    }

    public int getInsuredSIDNumberReps() {
        return this.getReps(49);
    }

    public CX getInsuredSIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(49, rep);
        return retVal;
    }

    public CX getIn149_InsuredSIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(49, rep);
        return retVal;
    }

    public int getIn149_InsuredSIDNumberReps() {
        return this.getReps(49);
    }

    public CX insertInsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(49, rep);
    }

    public CX insertIn149_InsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(49, rep);
    }

    public CX removeInsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(49, rep);
    }

    public CX removeIn149_InsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(49, rep);
    }

    public IS getSignatureCode() {
        IS retVal = (IS)this.getTypedField(50, 0);
        return retVal;
    }

    public IS getIn150_SignatureCode() {
        IS retVal = (IS)this.getTypedField(50, 0);
        return retVal;
    }

    public DT getSignatureCodeDate() {
        DT retVal = (DT)this.getTypedField(51, 0);
        return retVal;
    }

    public DT getIn151_SignatureCodeDate() {
        DT retVal = (DT)this.getTypedField(51, 0);
        return retVal;
    }

    public ST getInsuredSBirthPlace() {
        ST retVal = (ST)this.getTypedField(52, 0);
        return retVal;
    }

    public ST getIn152_InsuredSBirthPlace() {
        ST retVal = (ST)this.getTypedField(52, 0);
        return retVal;
    }

    public IS getVIPIndicator() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    public IS getIn153_VIPIndicator() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new XON(this.getMessage());
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new XON(this.getMessage());
            }
            case 11: {
                return new DT(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new AUI(this.getMessage());
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(86));
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new DTM(this.getMessage());
            }
            case 18: {
                return new XAD(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(135));
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(173));
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new IS(this.getMessage(), new Integer(93));
            }
            case 27: {
                return new ST(this.getMessage());
            }
            case 28: {
                return new DTM(this.getMessage());
            }
            case 29: {
                return new XCN(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(98));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(22));
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(42));
            }
            case 35: {
                return new ST(this.getMessage());
            }
            case 36: {
                return new CP(this.getMessage());
            }
            case 37: {
                return new NULLDT(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new NULLDT(this.getMessage());
            }
            case 40: {
                return new NULLDT(this.getMessage());
            }
            case 41: {
                return new CWE(this.getMessage());
            }
            case 42: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 43: {
                return new XAD(this.getMessage());
            }
            case 44: {
                return new ST(this.getMessage());
            }
            case 45: {
                return new IS(this.getMessage(), new Integer(72));
            }
            case 46: {
                return new IS(this.getMessage(), new Integer(309));
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 48: {
                return new CX(this.getMessage());
            }
            case 49: {
                return new IS(this.getMessage(), new Integer(535));
            }
            case 50: {
                return new DT(this.getMessage());
            }
            case 51: {
                return new ST(this.getMessage());
            }
            case 52: {
                return new IS(this.getMessage(), new Integer(99));
            }
        }
        return null;
    }
}

