/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.VXR_V03_INSURANCE;
import ca.uhn.hl7v2.model.v251.group.VXR_V03_ORDER;
import ca.uhn.hl7v2.model.v251.group.VXR_V03_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.GT1;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NK1;
import ca.uhn.hl7v2.model.v251.segment.PD1;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXR_V03
extends AbstractMessage {
    public VXR_V03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public VXR_V03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(SFT.class, false, true);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXR_V03_PATIENT_VISIT.class, false, false);
            this.add(GT1.class, false, true);
            this.add(VXR_V03_INSURANCE.class, false, true);
            this.add(VXR_V03_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VXR_V03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXR_V03_PATIENT_VISIT getPATIENT_VISIT() {
        return (VXR_V03_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", VXR_V03_PATIENT_VISIT.class);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public VXR_V03_INSURANCE getINSURANCE() {
        return (VXR_V03_INSURANCE)this.getTyped("INSURANCE", VXR_V03_INSURANCE.class);
    }

    public VXR_V03_INSURANCE getINSURANCE(int rep) {
        return (VXR_V03_INSURANCE)this.getTyped("INSURANCE", rep, VXR_V03_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<VXR_V03_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", VXR_V03_INSURANCE.class);
    }

    public void insertINSURANCE(VXR_V03_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public VXR_V03_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (VXR_V03_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public VXR_V03_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (VXR_V03_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public VXR_V03_ORDER getORDER() {
        return (VXR_V03_ORDER)this.getTyped("ORDER", VXR_V03_ORDER.class);
    }

    public VXR_V03_ORDER getORDER(int rep) {
        return (VXR_V03_ORDER)this.getTyped("ORDER", rep, VXR_V03_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<VXR_V03_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", VXR_V03_ORDER.class);
    }

    public void insertORDER(VXR_V03_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public VXR_V03_ORDER insertORDER(int rep) throws HL7Exception {
        return (VXR_V03_ORDER)super.insertRepetition("ORDER", rep);
    }

    public VXR_V03_ORDER removeORDER(int rep) throws HL7Exception {
        return (VXR_V03_ORDER)super.removeRepetition("ORDER", rep);
    }
}

