/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.FT;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PEO
extends AbstractSegment {
    public PEO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Event Identifiers Used");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Event Symptom/Diagnosis Code");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Event Onset Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Event Exacerbation Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Event Improved Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Event Ended Data/Time");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Event Location Occurred Address");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage()}, "Event Qualification");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Event Serious");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Event Expected");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage()}, "Event Outcome");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Patient Outcome");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage(), new Integer(0)}, "Event Description From Others");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage(), new Integer(0)}, "Event From Original Reporter");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage(), new Integer(0)}, "Event Description From Patient");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage(), new Integer(0)}, "Event Description From Practitioner");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage(), new Integer(0)}, "Event Description From Autopsy");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Cause Of Death");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Primary Observer Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Primary Observer Address");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Primary Observer Telephone");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Primary Observer's Qualification");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Confirmation Provided By");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Primary Observer Aware Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Primary Observer's identity May Be Divulged");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PEO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE[] getEventIdentifiersUsed() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventIdentifiersUsedReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getEventIdentifiersUsed(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPeo1_EventIdentifiersUsed(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo1_EventIdentifiersUsedReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertEventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE insertPeo1_EventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE removeEventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE removePeo1_EventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE[] getEventSymptomDiagnosisCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventSymptomDiagnosisCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getEventSymptomDiagnosisCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPeo2_EventSymptomDiagnosisCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo2_EventSymptomDiagnosisCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertEventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeEventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public TS getEventOnsetDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPeo3_EventOnsetDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEventExacerbationDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPeo4_EventExacerbationDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEventImprovedDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPeo5_EventImprovedDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEventEndedDataTime() {
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPeo6_EventEndedDataTime() {
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD[] getEventLocationOccurredAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventLocationOccurredAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD getEventLocationOccurredAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getPeo7_EventLocationOccurredAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo7_EventLocationOccurredAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertEventLocationOccurredAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD insertPeo7_EventLocationOccurredAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD removeEventLocationOccurredAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public XAD removePeo7_EventLocationOccurredAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public ID[] getEventQualification() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(8);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventQualificationReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID getEventQualification(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo8_EventQualification(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo8_EventQualificationReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID insertEventQualification(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertPeo8_EventQualification(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeEventQualification(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removePeo8_EventQualification(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID getEventSerious() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo9_EventSerious() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getEventExpected() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo10_EventExpected() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID[] getEventOutcome() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(11);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventOutcomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID getEventOutcome(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo11_EventOutcome(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo11_EventOutcomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID insertEventOutcome(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID insertPeo11_EventOutcome(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID removeEventOutcome(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID removePeo11_EventOutcome(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID getPatientOutcome() {
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo12_PatientOutcome() {
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT[] getEventDescriptionFromOthers() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(13);
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventDescriptionFromOthersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT getEventDescriptionFromOthers(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT getPeo13_EventDescriptionFromOthers(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo13_EventDescriptionFromOthersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT insertEventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(13, rep);
    }

    public FT insertPeo13_EventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(13, rep);
    }

    public FT removeEventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(13, rep);
    }

    public FT removePeo13_EventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(13, rep);
    }

    public FT[] getEventFromOriginalReporter() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(14);
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventFromOriginalReporterReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT getEventFromOriginalReporter(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT getPeo14_EventFromOriginalReporter(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo14_EventFromOriginalReporterReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT insertEventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(14, rep);
    }

    public FT insertPeo14_EventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(14, rep);
    }

    public FT removeEventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(14, rep);
    }

    public FT removePeo14_EventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(14, rep);
    }

    public FT[] getEventDescriptionFromPatient() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(15);
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventDescriptionFromPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT getEventDescriptionFromPatient(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT getPeo15_EventDescriptionFromPatient(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo15_EventDescriptionFromPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT insertEventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(15, rep);
    }

    public FT insertPeo15_EventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(15, rep);
    }

    public FT removeEventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(15, rep);
    }

    public FT removePeo15_EventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(15, rep);
    }

    public FT[] getEventDescriptionFromPractitioner() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventDescriptionFromPractitionerReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT getEventDescriptionFromPractitioner(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT getPeo16_EventDescriptionFromPractitioner(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo16_EventDescriptionFromPractitionerReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT insertEventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(16, rep);
    }

    public FT insertPeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(16, rep);
    }

    public FT removeEventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(16, rep);
    }

    public FT removePeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(16, rep);
    }

    public FT[] getEventDescriptionFromAutopsy() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEventDescriptionFromAutopsyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT getEventDescriptionFromAutopsy(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FT getPeo17_EventDescriptionFromAutopsy(int rep) {
        FT ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (FT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo17_EventDescriptionFromAutopsyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FT insertEventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(17, rep);
    }

    public FT insertPeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(17, rep);
    }

    public FT removeEventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(17, rep);
    }

    public FT removePeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(17, rep);
    }

    public CE[] getCauseOfDeath() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(18);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCauseOfDeathReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getCauseOfDeath(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPeo18_CauseOfDeath(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo18_CauseOfDeathReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertCauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE insertPeo18_CauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE removeCauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public CE removePeo18_CauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public XPN[] getPrimaryObserverName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPrimaryObserverNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getPrimaryObserverName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getPeo19_PrimaryObserverName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo19_PrimaryObserverNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertPrimaryObserverName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(19, rep);
    }

    public XPN insertPeo19_PrimaryObserverName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(19, rep);
    }

    public XPN removePrimaryObserverName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(19, rep);
    }

    public XPN removePeo19_PrimaryObserverName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(19, rep);
    }

    public XAD[] getPrimaryObserverAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(20);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPrimaryObserverAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD getPrimaryObserverAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getPeo20_PrimaryObserverAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo20_PrimaryObserverAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertPrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(20, rep);
    }

    public XAD insertPeo20_PrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(20, rep);
    }

    public XAD removePrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(20, rep);
    }

    public XAD removePeo20_PrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(20, rep);
    }

    public XTN[] getPrimaryObserverTelephone() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPrimaryObserverTelephoneReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getPrimaryObserverTelephone(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getPeo21_PrimaryObserverTelephone(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPeo21_PrimaryObserverTelephoneReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertPrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN insertPeo21_PrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN removePrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public XTN removePeo21_PrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public ID getPrimaryObserverSQualification() {
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo22_PrimaryObserverSQualification() {
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getConfirmationProvidedBy() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo23_ConfirmationProvidedBy() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPrimaryObserverAwareDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPeo24_PrimaryObserverAwareDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPrimaryObserverSIdentityMayBeDivulged() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPeo25_PrimaryObserverSIdentityMayBeDivulged() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new XAD(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(237));
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(238));
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(239));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(240));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(241));
            }
            case 12: {
                return new FT(this.getMessage());
            }
            case 13: {
                return new FT(this.getMessage());
            }
            case 14: {
                return new FT(this.getMessage());
            }
            case 15: {
                return new FT(this.getMessage());
            }
            case 16: {
                return new FT(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new XPN(this.getMessage());
            }
            case 19: {
                return new XAD(this.getMessage());
            }
            case 20: {
                return new XTN(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 23: {
                return new TS(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(243));
            }
        }
        return null;
    }
}

