/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.MFR_M01_MF_QUERY;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MFI;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFR_M01
extends AbstractMessage {
    public MFR_M01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFR_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M01_MF_QUERY.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFR_M01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFR_M01_MF_QUERY getMF_QUERY() {
        return (MFR_M01_MF_QUERY)this.getTyped("MF_QUERY", MFR_M01_MF_QUERY.class);
    }

    public MFR_M01_MF_QUERY getMF_QUERY(int rep) {
        return (MFR_M01_MF_QUERY)this.getTyped("MF_QUERY", rep, MFR_M01_MF_QUERY.class);
    }

    public int getMF_QUERYReps() {
        return this.getReps("MF_QUERY");
    }

    public List<MFR_M01_MF_QUERY> getMF_QUERYAll() throws HL7Exception {
        return this.getAllAsList("MF_QUERY", MFR_M01_MF_QUERY.class);
    }

    public void insertMF_QUERY(MFR_M01_MF_QUERY structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_QUERY", (Structure)structure, rep);
    }

    public MFR_M01_MF_QUERY insertMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M01_MF_QUERY)super.insertRepetition("MF_QUERY", rep);
    }

    public MFR_M01_MF_QUERY removeMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M01_MF_QUERY)super.removeRepetition("MF_QUERY", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

