/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.segment.DB1;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PD1;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.PV1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A24
extends AbstractMessage {
    public ADT_A24() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A24(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, false, false);
            this.add(DB1.class, false, true);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, false, false);
            this.add(DB1.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A24 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public DB1 getDB1() {
        return (DB1)this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return (DB1)this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public PID getPID2() {
        return (PID)this.getTyped("PID2", PID.class);
    }

    public PD1 getPD12() {
        return (PD1)this.getTyped("PD12", PD1.class);
    }

    public PV1 getPV12() {
        return (PV1)this.getTyped("PV12", PV1.class);
    }

    public DB1 getDB12() {
        return (DB1)this.getTyped("DB12", DB1.class);
    }

    public DB1 getDB12(int rep) {
        return (DB1)this.getTyped("DB12", rep, DB1.class);
    }

    public int getDB12Reps() {
        return this.getReps("DB12");
    }

    public List<DB1> getDB12All() throws HL7Exception {
        return this.getAllAsList("DB12", DB1.class);
    }

    public void insertDB12(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB12", (Structure)structure, rep);
    }

    public DB1 insertDB12(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB12", rep);
    }

    public DB1 removeDB12(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB12", rep);
    }
}

