/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.SQR_S25_PATIENT;
import ca.uhn.hl7v2.model.v24.group.SQR_S25_RESOURCES;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.SCH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SQR_S25_SCHEDULE
extends AbstractGroup {
    public SQR_S25_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCH.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(SQR_S25_PATIENT.class, false, false, false);
            this.add(SQR_S25_RESOURCES.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SQR_S25_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public SCH getSCH() {
        SCH retVal = (SCH)this.getTyped("SCH", SCH.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SQR_S25_PATIENT getPATIENT() {
        SQR_S25_PATIENT retVal = (SQR_S25_PATIENT)this.getTyped("PATIENT", SQR_S25_PATIENT.class);
        return retVal;
    }

    public SQR_S25_RESOURCES getRESOURCES() {
        SQR_S25_RESOURCES retVal = (SQR_S25_RESOURCES)this.getTyped("RESOURCES", SQR_S25_RESOURCES.class);
        return retVal;
    }

    public SQR_S25_RESOURCES getRESOURCES(int rep) {
        SQR_S25_RESOURCES retVal = (SQR_S25_RESOURCES)this.getTyped("RESOURCES", rep, SQR_S25_RESOURCES.class);
        return retVal;
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SQR_S25_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SQR_S25_RESOURCES.class);
    }

    public void insertRESOURCES(SQR_S25_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", (Structure)structure, rep);
    }

    public SQR_S25_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SQR_S25_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

