/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.OMG_O19_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.OMG_O19_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v24.segment.BLG;
import ca.uhn.hl7v2.model.v24.segment.CTD;
import ca.uhn.hl7v2.model.v24.segment.CTI;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.OBR;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMG_O19_ORDER
extends AbstractGroup {
    public OMG_O19_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OMG_O19_OBSERVATION.class, false, true, false);
            this.add(OMG_O19_PRIOR_RESULT.class, false, true, false);
            this.add(FT1.class, false, true, false);
            this.add(CTI.class, false, true, false);
            this.add(BLG.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMG_O19_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = (DG1)this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = (DG1)this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OMG_O19_OBSERVATION getOBSERVATION() {
        OMG_O19_OBSERVATION retVal = (OMG_O19_OBSERVATION)this.getTyped("OBSERVATION", OMG_O19_OBSERVATION.class);
        return retVal;
    }

    public OMG_O19_OBSERVATION getOBSERVATION(int rep) {
        OMG_O19_OBSERVATION retVal = (OMG_O19_OBSERVATION)this.getTyped("OBSERVATION", rep, OMG_O19_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OMG_O19_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OMG_O19_OBSERVATION.class);
    }

    public void insertOBSERVATION(OMG_O19_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OMG_O19_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OMG_O19_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OMG_O19_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OMG_O19_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OMG_O19_PRIOR_RESULT getPRIOR_RESULT() {
        OMG_O19_PRIOR_RESULT retVal = (OMG_O19_PRIOR_RESULT)this.getTyped("PRIOR_RESULT", OMG_O19_PRIOR_RESULT.class);
        return retVal;
    }

    public OMG_O19_PRIOR_RESULT getPRIOR_RESULT(int rep) {
        OMG_O19_PRIOR_RESULT retVal = (OMG_O19_PRIOR_RESULT)this.getTyped("PRIOR_RESULT", rep, OMG_O19_PRIOR_RESULT.class);
        return retVal;
    }

    public int getPRIOR_RESULTReps() {
        return this.getReps("PRIOR_RESULT");
    }

    public List<OMG_O19_PRIOR_RESULT> getPRIOR_RESULTAll() throws HL7Exception {
        return this.getAllAsList("PRIOR_RESULT", OMG_O19_PRIOR_RESULT.class);
    }

    public void insertPRIOR_RESULT(OMG_O19_PRIOR_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRIOR_RESULT", (Structure)structure, rep);
    }

    public OMG_O19_PRIOR_RESULT insertPRIOR_RESULT(int rep) throws HL7Exception {
        return (OMG_O19_PRIOR_RESULT)super.insertRepetition("PRIOR_RESULT", rep);
    }

    public OMG_O19_PRIOR_RESULT removePRIOR_RESULT(int rep) throws HL7Exception {
        return (OMG_O19_PRIOR_RESULT)super.removeRepetition("PRIOR_RESULT", rep);
    }

    public FT1 getFT1() {
        FT1 retVal = (FT1)this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = (FT1)this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public BLG getBLG() {
        BLG retVal = (BLG)this.getTyped("BLG", BLG.class);
        return retVal;
    }
}

