/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.FT;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;

public class CF
extends AbstractComposite {
    private Type[] data;

    public CF(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new ID(this.getMessage(), 0);
        this.data[1] = new FT(this.getMessage());
        this.data[2] = new IS(this.getMessage(), 0);
        this.data[3] = new ID(this.getMessage(), 0);
        this.data[4] = new FT(this.getMessage());
        this.data[5] = new IS(this.getMessage(), 0);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ID getIdentifier() {
        return (ID)this.getTyped(0, ID.class);
    }

    public ID getCf1_Identifier() {
        return (ID)this.getTyped(0, ID.class);
    }

    public FT getFormattedText() {
        return (FT)this.getTyped(1, FT.class);
    }

    public FT getCf2_FormattedText() {
        return (FT)this.getTyped(1, FT.class);
    }

    public IS getNameOfCodingSystem() {
        return (IS)this.getTyped(2, IS.class);
    }

    public IS getCf3_NameOfCodingSystem() {
        return (IS)this.getTyped(2, IS.class);
    }

    public ID getAlternateIdentifier() {
        return (ID)this.getTyped(3, ID.class);
    }

    public ID getCf4_AlternateIdentifier() {
        return (ID)this.getTyped(3, ID.class);
    }

    public FT getAlternateFormattedText() {
        return (FT)this.getTyped(4, FT.class);
    }

    public FT getCf5_AlternateFormattedText() {
        return (FT)this.getTyped(4, FT.class);
    }

    public IS getNameOfAlternateCodingSystem() {
        return (IS)this.getTyped(5, IS.class);
    }

    public IS getCf6_NameOfAlternateCodingSystem() {
        return (IS)this.getTyped(5, IS.class);
    }
}

