/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.PPG_PCG_PATHWAY;
import ca.uhn.hl7v2.model.v24.group.PPG_PCG_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPG_PCG
extends AbstractMessage {
    public PPG_PCG() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPG_PCG(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPG_PCG_PATIENT_VISIT.class, false, false);
            this.add(PPG_PCG_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PPG_PCG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PPG_PCG_PATIENT_VISIT getPATIENT_VISIT() {
        return (PPG_PCG_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PPG_PCG_PATIENT_VISIT.class);
    }

    public PPG_PCG_PATHWAY getPATHWAY() {
        return (PPG_PCG_PATHWAY)this.getTyped("PATHWAY", PPG_PCG_PATHWAY.class);
    }

    public PPG_PCG_PATHWAY getPATHWAY(int rep) {
        return (PPG_PCG_PATHWAY)this.getTyped("PATHWAY", rep, PPG_PCG_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPG_PCG_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPG_PCG_PATHWAY.class);
    }

    public void insertPATHWAY(PPG_PCG_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPG_PCG_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPG_PCG_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

