/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.ADT_A06_IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.ADT_A06_PR1ROL;
import ca.uhn.hl7v2.model.v231.segment.ACC;
import ca.uhn.hl7v2.model.v231.segment.AL1;
import ca.uhn.hl7v2.model.v231.segment.DB1;
import ca.uhn.hl7v2.model.v231.segment.DG1;
import ca.uhn.hl7v2.model.v231.segment.DRG;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.GT1;
import ca.uhn.hl7v2.model.v231.segment.MRG;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.OBX;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v231.segment.PV1;
import ca.uhn.hl7v2.model.v231.segment.PV2;
import ca.uhn.hl7v2.model.v231.segment.UB1;
import ca.uhn.hl7v2.model.v231.segment.UB2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A06
extends AbstractMessage {
    public ADT_A06() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(MRG.class, false, false);
            this.add(NK1.class, false, true);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(AL1.class, false, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(ADT_A06_PR1ROL.class, false, true);
            this.add(GT1.class, false, true);
            this.add(ADT_A06_IN1IN2IN3.class, false, true);
            this.add(ACC.class, false, false);
            this.add(UB1.class, false, false);
            this.add(UB2.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public MRG getMRG() {
        return (MRG)this.getTyped("MRG", MRG.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return (PV2)this.getTyped("PV2", PV2.class);
    }

    public DB1 getDB1() {
        return (DB1)this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return (DB1)this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        return (OBX)this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return (OBX)this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        return (AL1)this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return (AL1)this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return (DG1)this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return (DRG)this.getTyped("DRG", DRG.class);
    }

    public ADT_A06_PR1ROL getPR1ROL() {
        return (ADT_A06_PR1ROL)this.getTyped("PR1ROL", ADT_A06_PR1ROL.class);
    }

    public ADT_A06_PR1ROL getPR1ROL(int rep) {
        return (ADT_A06_PR1ROL)this.getTyped("PR1ROL", rep, ADT_A06_PR1ROL.class);
    }

    public int getPR1ROLReps() {
        return this.getReps("PR1ROL");
    }

    public List<ADT_A06_PR1ROL> getPR1ROLAll() throws HL7Exception {
        return this.getAllAsList("PR1ROL", ADT_A06_PR1ROL.class);
    }

    public void insertPR1ROL(ADT_A06_PR1ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("PR1ROL", (Structure)structure, rep);
    }

    public ADT_A06_PR1ROL insertPR1ROL(int rep) throws HL7Exception {
        return (ADT_A06_PR1ROL)super.insertRepetition("PR1ROL", rep);
    }

    public ADT_A06_PR1ROL removePR1ROL(int rep) throws HL7Exception {
        return (ADT_A06_PR1ROL)super.removeRepetition("PR1ROL", rep);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADT_A06_IN1IN2IN3 getIN1IN2IN3() {
        return (ADT_A06_IN1IN2IN3)this.getTyped("IN1IN2IN3", ADT_A06_IN1IN2IN3.class);
    }

    public ADT_A06_IN1IN2IN3 getIN1IN2IN3(int rep) {
        return (ADT_A06_IN1IN2IN3)this.getTyped("IN1IN2IN3", rep, ADT_A06_IN1IN2IN3.class);
    }

    public int getIN1IN2IN3Reps() {
        return this.getReps("IN1IN2IN3");
    }

    public List<ADT_A06_IN1IN2IN3> getIN1IN2IN3All() throws HL7Exception {
        return this.getAllAsList("IN1IN2IN3", ADT_A06_IN1IN2IN3.class);
    }

    public void insertIN1IN2IN3(ADT_A06_IN1IN2IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1IN2IN3", (Structure)structure, rep);
    }

    public ADT_A06_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception {
        return (ADT_A06_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }

    public ADT_A06_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception {
        return (ADT_A06_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }

    public ACC getACC() {
        return (ACC)this.getTyped("ACC", ACC.class);
    }

    public UB1 getUB1() {
        return (UB1)this.getTyped("UB1", UB1.class);
    }

    public UB2 getUB2() {
        return (UB2)this.getTyped("UB2", UB2.class);
    }
}

