/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSS
extends AbstractSegment {
    public CSS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Study Scheduled Time Point");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Study Scheduled Patient Time Point");
            this.add(CE.class, false, 3, 60, new Object[]{this.getMessage()}, "Study Quality Control Codes");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CSS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getStudyScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getCss1_StudyScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getStudyScheduledPatientTimePoint() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getCss2_StudyScheduledPatientTimePoint() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE[] getStudyQualityControlCodes() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getCss3_StudyQualityControlCodes() {
        CE[] retVal = (CE[])this.getTypedField(3, (Type[])new CE[0]);
        return retVal;
    }

    public int getStudyQualityControlCodesReps() {
        return this.getReps(3);
    }

    public CE getStudyQualityControlCodes(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getCss3_StudyQualityControlCodes(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getCss3_StudyQualityControlCodesReps() {
        return this.getReps(3);
    }

    public CE insertStudyQualityControlCodes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertCss3_StudyQualityControlCodes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeStudyQualityControlCodes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeCss3_StudyQualityControlCodes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

