/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v22.group.MFR_M03_MF_TEST;
import ca.uhn.hl7v2.model.v22.segment.DSC;
import ca.uhn.hl7v2.model.v22.segment.ERR;
import ca.uhn.hl7v2.model.v22.segment.MFI;
import ca.uhn.hl7v2.model.v22.segment.MSA;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.QRD;
import ca.uhn.hl7v2.model.v22.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFR_M03
extends AbstractMessage {
    public MFR_M03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFR_M03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M03_MF_TEST.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFR_M03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFR_M03_MF_TEST getMF_TEST() {
        return (MFR_M03_MF_TEST)this.getTyped("MF_TEST", MFR_M03_MF_TEST.class);
    }

    public MFR_M03_MF_TEST getMF_TEST(int rep) {
        return (MFR_M03_MF_TEST)this.getTyped("MF_TEST", rep, MFR_M03_MF_TEST.class);
    }

    public int getMF_TESTReps() {
        return this.getReps("MF_TEST");
    }

    public List<MFR_M03_MF_TEST> getMF_TESTAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST", MFR_M03_MF_TEST.class);
    }

    public void insertMF_TEST(MFR_M03_MF_TEST structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST", (Structure)structure, rep);
    }

    public MFR_M03_MF_TEST insertMF_TEST(int rep) throws HL7Exception {
        return (MFR_M03_MF_TEST)super.insertRepetition("MF_TEST", rep);
    }

    public MFR_M03_MF_TEST removeMF_TEST(int rep) throws HL7Exception {
        return (MFR_M03_MF_TEST)super.removeRepetition("MF_TEST", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

