/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v22.segment.DSC;
import ca.uhn.hl7v2.model.v22.segment.DSP;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.URD;
import ca.uhn.hl7v2.model.v22.segment.URS;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDM_Q05
extends AbstractMessage {
    public UDM_Q05() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public UDM_Q05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(URD.class, true, false);
            this.add(URS.class, false, false);
            this.add(DSP.class, true, true);
            this.add(DSC.class, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating UDM_Q05 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public URD getURD() {
        return (URD)this.getTyped("URD", URD.class);
    }

    public URS getURS() {
        return (URS)this.getTyped("URS", URS.class);
    }

    public DSP getDSP() {
        return (DSP)this.getTyped("DSP", DSP.class);
    }

    public DSP getDSP(int rep) {
        return (DSP)this.getTyped("DSP", rep, DSP.class);
    }

    public int getDSPReps() {
        return this.getReps("DSP");
    }

    public List<DSP> getDSPAll() throws HL7Exception {
        return this.getAllAsList("DSP", DSP.class);
    }

    public void insertDSP(DSP structure, int rep) throws HL7Exception {
        super.insertRepetition("DSP", (Structure)structure, rep);
    }

    public DSP insertDSP(int rep) throws HL7Exception {
        return (DSP)super.insertRepetition("DSP", rep);
    }

    public DSP removeDSP(int rep) throws HL7Exception {
        return (DSP)super.removeRepetition("DSP", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

