/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.relay;

import ca.uhn.hl7v2.hoh.util.IOUtils;
import ca.uhn.hl7v2.hoh.util.VersionLogger;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Launcher {
    private static final Logger ourLog = LoggerFactory.getLogger(Launcher.class);
    private FileSystemXmlApplicationContext myAppContext;

    public Launcher() {
        this("conf" + IOUtils.FILE_PATH_SEP + "config.xml");
    }

    public Launcher(String configFile) {
        long start = System.currentTimeMillis();
        String b = "HAPI HL7 over HTTP Relay is starting. This software is Licensed under the Apache Software License (version 2.0) and is Copyright(c) 2012 University Health Network.";
        ourLog.info(b);
        VersionLogger.init();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.myAppContext = new FileSystemXmlApplicationContext(configFile);
        this.myAppContext.start();
        long delay = System.currentTimeMillis() - start;
        ourLog.info("HAPI HL7 over HTTP Relay started in {} ms", (Object)delay);
    }

    public ApplicationContext getAppCtx() {
        return this.myAppContext;
    }

    public void shutdown() {
        ourLog.info("Shutdown request detected, stopping all services");
        if (this.myAppContext != null) {
            this.myAppContext.close();
            this.myAppContext = null;
        }
        ourLog.info("Shutdown request completed");
    }

    public static void main(String[] args) throws FileNotFoundException {
        new Launcher();
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            Launcher.this.shutdown();
        }
    }
}

