/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IClientSimple;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.api.MessageMetadataKeys;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialClientCallback;
import ca.uhn.hl7v2.hoh.raw.api.RawSendable;
import ca.uhn.hl7v2.hoh.raw.client.AbstractRawClient;
import ca.uhn.hl7v2.hoh.sockets.TlsSocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;

public class HohRawClientSimple
extends AbstractRawClient
implements IClientSimple {
    private boolean myAutoClose = true;
    private Socket mySocket;

    public HohRawClientSimple(String theHost, int thePort, String theUriPath) {
        super(theHost, thePort, theUriPath);
    }

    @Override
    public synchronized IReceivable<String> sendAndReceive(ISendable<?> theMessageToSend) throws DecodeException, IOException, EncodeException {
        return super.sendAndReceive(theMessageToSend);
    }

    public HohRawClientSimple(URL theUrl) {
        super(theUrl);
    }

    @Override
    public void close() {
        if (this.mySocket != null) {
            this.closeSocket(this.mySocket);
        }
    }

    @Override
    public boolean isAutoClose() {
        return this.myAutoClose;
    }

    @Override
    public boolean isConnected() {
        return this.isSocketConnected(this.mySocket);
    }

    @Override
    protected Socket provideSocket() throws IOException {
        if (this.mySocket == null || this.mySocket.isClosed() || this.mySocket.isInputShutdown() || this.mySocket.isOutputShutdown()) {
            this.mySocket = this.connect();
        }
        return this.mySocket;
    }

    @Override
    protected void returnSocket(Socket theSocket) {
        if (this.isAutoClose()) {
            this.close();
        }
    }

    @Override
    public void setAutoClose(boolean theAutoClose) {
        this.myAutoClose = theAutoClose;
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 8080;
        String uri = "/AppContext";
        HohRawClientSimple client = new HohRawClientSimple(host, port, uri);
        client.setSocketFactory(new TlsSocketFactory());
        SingleCredentialClientCallback authCalback = new SingleCredentialClientCallback("ausername", "somepassword");
        client.setAuthorizationCallback(authCalback);
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        RawSendable sendable = new RawSendable(message);
        try {
            IReceivable<String> receivable = client.sendAndReceive(sendable);
            System.out.println("Response was:\n" + receivable.getMessage());
            String remoteHostIp = (String)receivable.getMetadata().get((Object)MessageMetadataKeys.REMOTE_HOST_ADDRESS);
            System.out.println("From:\n" + remoteHostIp);
        }
        catch (DecodeException | EncodeException | IOException e) {
            e.printStackTrace();
        }
    }
}

