/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class SplitInputStream
extends InputStream {
    private int myBytesUntilSplit;
    private InputStream myWrap;

    public SplitInputStream(InputStream theWrap, int theSplitPoint) {
        this.myBytesUntilSplit = theSplitPoint;
        this.myWrap = theWrap;
    }

    public int read(byte[] theB) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] theB, int theOff, int theLen) throws IOException {
        if (this.myBytesUntilSplit >= 0) {
            if (this.myBytesUntilSplit > 0 && theLen > this.myBytesUntilSplit) {
                theLen = this.myBytesUntilSplit;
            } else {
                this.myBytesUntilSplit = -1;
                theLen = 0;
                throw new SocketTimeoutException();
            }
        }
        int retVal = this.myWrap.read(theB, theOff, theLen);
        this.myBytesUntilSplit -= retVal;
        return retVal;
    }

    public long skip(long theN) throws IOException {
        this.myBytesUntilSplit = (int)((long)this.myBytesUntilSplit - theN);
        return this.myWrap.skip(theN);
    }

    public int available() throws IOException {
        return this.myBytesUntilSplit >= 0 ? Math.min(this.myBytesUntilSplit, this.myWrap.available()) : this.myWrap.available();
    }

    public void close() throws IOException {
        this.myWrap.close();
    }

    public synchronized void mark(int theReadlimit) {
        throw new UnsupportedOperationException();
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        if (this.myBytesUntilSplit == 0) {
            --this.myBytesUntilSplit;
            throw new SocketTimeoutException();
        }
        int retVal = this.myWrap.read();
        if (retVal != -1) {
            --this.myBytesUntilSplit;
        }
        return retVal;
    }
}

