/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialClientCallback;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialServerCallback;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.llp.ServerSocketThreadForTesting;
import ca.uhn.hl7v2.hoh.raw.api.RawSendable;
import ca.uhn.hl7v2.hoh.raw.client.HohRawClientMultithreaded;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import java.net.SocketException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HohRawClientMultithreadedTest {
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawClientMultithreadedTest.class);
    private static int myPort;
    private static Hl7OverHttpLowerLayerProtocol myLlp;
    private static SingleCredentialServerCallback ourServerCallback;
    private static ServerSocketThreadForTesting myServerSocketThread;

    @Test
    public void testSendMessageSimple() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        HohRawClientMultithreaded client = new HohRawClientMultithreaded("localhost", myPort, "/theUri");
        client.setSocketTimeout(500L);
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourLog.info("*** Send message #1");
        IReceivable<String> response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)1L, (long)myServerSocketThread.getConnectionCount());
        ourLog.info("*** Send message #2");
        response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)1L, (long)myServerSocketThread.getConnectionCount());
        Thread.sleep(1000L);
        ourLog.info("*** Send message #3");
        response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)2L, (long)myServerSocketThread.getConnectionCount());
    }

    @Test
    public void testSendMessageWithNoTimeout() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        HohRawClientMultithreaded client = new HohRawClientMultithreaded("localhost", myPort, "/theUri");
        client.setSocketTimeout(-1L);
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourLog.info("*** Send message #1");
        IReceivable<String> response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)1L, (long)myServerSocketThread.getConnectionCount());
        Thread.sleep(1000L);
        ourLog.info("*** Send message #2");
        response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)1L, (long)myServerSocketThread.getConnectionCount());
    }

    @Test
    public void testReconnectAutomaticallyAfterUnexpectedClose() throws Exception {
        myServerSocketThread.setCloseUnexpectedlyAfterEachMessage();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        HohRawClientMultithreaded client = new HohRawClientMultithreaded("localhost", myPort, "/theUri");
        client.setSocketTimeout(1000L);
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourLog.info("*** Send message #1");
        IReceivable<String> response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)1L, (long)myServerSocketThread.getConnectionCount());
        Thread.sleep(100L);
        ourLog.info("*** Send message #2");
        try {
            response = client.sendAndReceive(new RawSendable(message));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        response = client.sendAndReceive(new RawSendable(message));
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
        Assert.assertEquals((long)2L, (long)myServerSocketThread.getConnectionCount());
    }

    @After
    public void after() throws InterruptedException {
        ourLog.info("Marking done as true");
        myServerSocketThread.done();
    }

    @Before
    public void before() throws InterruptedException {
        myPort = RandomServerPortProvider.findFreePort();
        myLlp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        myLlp.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourServerCallback = new SingleCredentialServerCallback("hello", "hapiworld");
        myServerSocketThread = new ServerSocketThreadForTesting(myPort, ourServerCallback);
        myServerSocketThread.start();
        myServerSocketThread.getLatch().await();
    }
}

