/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttp;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.sign.SignatureFailureException;
import ca.uhn.hl7v2.hoh.util.GZipUtils;
import ca.uhn.hl7v2.hoh.util.HTTPUtils;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHl7OverHttpEncoder
extends AbstractHl7OverHttp {
    private static final Logger ourLog = LoggerFactory.getLogger(AbstractHl7OverHttpEncoder.class);
    private static DateFormat ourRfc1123DateFormat = new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss z");
    private String myActionLine;
    private boolean myGzipData;
    private ISendable<?> mySendable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode() throws EncodeException {
        Object os;
        ourLog.trace("Entering encode()");
        this.verifyNotUsed();
        if (StringUtils.isBlank(this.getMessage()) && this.mySendable == null) {
            throw new IllegalStateException("Either Message or Sendable must be set");
        }
        if (this.getMessage() != null) {
            byte[] bytes = this.getMessage().getBytes(this.getCharset());
            if (this.myGzipData) {
                try {
                    bytes = GZipUtils.compress(bytes);
                }
                catch (IOException e) {
                    throw new EncodeException("Failed to apply GZip coding", e);
                }
            }
            this.setData(bytes);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.myGzipData) {
                try {
                    os = new GZIPOutputStream(bos);
                }
                catch (IOException e) {
                    throw new EncodeException("Failed to create GZip encoder", e);
                }
            } else {
                os = bos;
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, this.getCharset());
            try {
                this.mySendable.writeMessage(w);
            }
            catch (IOException e) {
                throw new EncodeException("Failed to convert message to sendable bytes");
            }
            this.setData(bos.toByteArray());
        }
        this.setActionLineAppropriately();
        this.setHeaders(new LinkedHashMap());
        StringBuilder ctBuilder = new StringBuilder();
        if (this.mySendable != null) {
            ctBuilder.append(this.mySendable.getEncodingStyle().getContentType());
        } else {
            ctBuilder.append(EncodingStyle.detect(this.getMessage()).getContentType());
        }
        ctBuilder.append("; charset=");
        ctBuilder.append(this.getCharset().name());
        this.getHeaders().put("Content-Type", ctBuilder.toString());
        this.getHeaders().put("Content-Length", Integer.toString(this.getData().length));
        this.addSpecificHeaders();
        os = ourRfc1123DateFormat;
        synchronized (os) {
            this.getHeaders().put("Date", ourRfc1123DateFormat.format(new Date()));
        }
        if (this.getSigner() != null) {
            try {
                this.getHeaders().put("HL7-Signature", this.getSigner().sign(this.getData()));
            }
            catch (SignatureFailureException e) {
                throw new EncodeException(e);
            }
        }
        ourLog.trace("Exiting encode()");
    }

    public void encodeToOutputStream(OutputStream theOutputStream) throws IOException, EncodeException {
        this.encode();
        ourLog.debug("Writing HTTP action: {}", (Object)this.getActionLine());
        OutputStreamWriter w = new OutputStreamWriter(theOutputStream, HTTPUtils.DEFAULT_CHARSET);
        w.write(this.getActionLine());
        w.write("\r\n");
        for (Map.Entry next : this.getHeaders().entrySet()) {
            ourLog.debug("Writing HTTP header- {}: {}", next.getKey(), next.getValue());
            w.write((String)next.getKey());
            w.write(": ");
            w.write((String)next.getValue());
            w.write("\r\n");
        }
        w.write("\r\n");
        w.flush();
        ourLog.debug("Writing {} bytes of actual data", (Object)this.getData().length);
        theOutputStream.write(this.getData());
    }

    public String getActionLine() {
        return this.myActionLine;
    }

    public void setActionLine(String theActionLine) {
        this.myActionLine = theActionLine;
    }

    public void setDataProvider(ISendable<?> theSendable) {
        if (this.getMessage() != null) {
            throw new IllegalStateException("Message already provided");
        }
        this.mySendable = theSendable;
    }

    @Override
    public void setMessage(String theData) {
        if (this.mySendable != null) {
            throw new IllegalStateException("Data provider already provided");
        }
        super.setMessage(theData);
    }

    protected abstract void addSpecificHeaders();

    protected abstract void setActionLineAppropriately();

    boolean isGzipData() {
        return this.myGzipData;
    }

    void setGzipData(boolean theGzipData) {
        this.myGzipData = theGzipData;
    }
}

