/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.ExtendedMinLLPReader;
import ca.uhn.hl7v2.llp.ExtendedMinLLPWriter;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLLPReader;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MinLowerLayerProtocol
extends LowerLayerProtocol {
    private final boolean respectMSH18;
    private final boolean omitBOM;

    public MinLowerLayerProtocol() {
        this(false, false);
    }

    public MinLowerLayerProtocol(boolean respectMSH18) {
        this(respectMSH18, false);
    }

    public MinLowerLayerProtocol(boolean respectMSH18, boolean omitBOM) {
        this.respectMSH18 = respectMSH18;
        this.omitBOM = omitBOM;
    }

    @Override
    public HL7Reader getReader(InputStream in) throws LLPException {
        try {
            return this.respectMSH18 ? new ExtendedMinLLPReader(in, this.charset) : new MinLLPReader(in, this.charset);
        }
        catch (IOException e) {
            throw new LLPException("Can't create Reader with the given input stream: " + e.getMessage(), e);
        }
    }

    @Override
    public HL7Writer getWriter(OutputStream out) throws LLPException {
        try {
            return this.respectMSH18 ? new ExtendedMinLLPWriter(out, this.charset, this.omitBOM) : new MinLLPWriter(out, this.charset, this.omitBOM);
        }
        catch (IOException e) {
            throw new LLPException("Can't create Writer with the given output stream: " + e.getMessage(), e);
        }
    }
}

