/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.classes.abs;

import ca.uhn.hl7v2.conf.classes.exceptions.ConfDataException;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConformanceDataType {
    private static final Logger log = LoggerFactory.getLogger(AbstractConformanceDataType.class);
    private final Primitive hapiPrimitive;

    public AbstractConformanceDataType(Primitive hapiPrimitive) {
        this.hapiPrimitive = hapiPrimitive;
        try {
            if (this.getConstantValue() != null) {
                this.setValue(this.getConstantValue());
            }
        }
        catch (ConfDataException e) {
            log.error("Could not enforce constant value.", (Throwable)e);
        }
    }

    public abstract String getConstantValue();

    public abstract long getMaxLength();

    protected void setValue(String value) throws ConfDataException {
        if (this.getMaxLength() > 0L && (long)value.length() > this.getMaxLength()) {
            throw new ConfDataException("DataType length exceeds the Maximum allowable length");
        }
        try {
            this.hapiPrimitive.setValue(value);
        }
        catch (DataTypeException e) {
            throw new ConfDataException("Invalid Data Populated");
        }
    }
}

