/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.EncodingRuleBinding;
import ca.uhn.hl7v2.validation.impl.MessageRuleBinding;
import ca.uhn.hl7v2.validation.impl.PrimitiveTypeRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidationContextImpl
implements ValidationContext,
Serializable {
    private List<RuleBinding<PrimitiveTypeRule>> myPrimitiveRuleBindings = new ArrayList<RuleBinding<PrimitiveTypeRule>>();
    private List<RuleBinding<MessageRule>> myMessageRuleBindings = new ArrayList<RuleBinding<MessageRule>>();
    private List<RuleBinding<EncodingRule>> myEncodingRuleBindings = new ArrayList<RuleBinding<EncodingRule>>();
    protected Map<String, Collection<PrimitiveTypeRule>> primitiveRuleCache;
    protected Map<String, Collection<MessageRule>> messageRuleCache;
    protected Map<String, Collection<EncodingRule>> encodingRuleCache;

    public ValidationContextImpl() {
        this.initCaches();
    }

    ValidationContextImpl(ValidationRuleBuilder builder) {
        this();
        for (RuleBinding<? extends Rule<?>> ruleBinding : builder.initialize()) {
            if (ruleBinding instanceof MessageRuleBinding) {
                this.myMessageRuleBindings.add((MessageRuleBinding)ruleBinding);
                continue;
            }
            if (ruleBinding instanceof EncodingRuleBinding) {
                this.myEncodingRuleBindings.add((EncodingRuleBinding)ruleBinding);
                continue;
            }
            if (!(ruleBinding instanceof PrimitiveTypeRuleBinding)) continue;
            this.myPrimitiveRuleBindings.add((PrimitiveTypeRuleBinding)ruleBinding);
        }
    }

    protected void initCaches() {
        this.primitiveRuleCache = ValidationContextImpl.newRuleCache(100);
        this.messageRuleCache = ValidationContextImpl.newRuleCache(100);
        this.encodingRuleCache = ValidationContextImpl.newRuleCache(10);
    }

    @Override
    public Collection<PrimitiveTypeRule> getPrimitiveRules(String theVersion, String theTypeName, Primitive theType) {
        Collection<PrimitiveTypeRule> rules = this.primitiveRuleCache.get(theVersion + theTypeName);
        if (rules == null) {
            rules = this.getRules(this.myPrimitiveRuleBindings, theVersion, theTypeName);
            this.primitiveRuleCache.put(theVersion + theTypeName, rules);
        }
        return rules;
    }

    public List<RuleBinding<PrimitiveTypeRule>> getPrimitiveRuleBindings() {
        return this.myPrimitiveRuleBindings;
    }

    @Override
    public Collection<MessageRule> getMessageRules(String theVersion, String theMessageType, String theTriggerEvent) {
        Collection<MessageRule> rules = this.messageRuleCache.get(theVersion + theMessageType + theTriggerEvent);
        if (rules == null) {
            rules = this.getRules(this.myMessageRuleBindings, theVersion, theMessageType + "^" + theTriggerEvent);
            this.messageRuleCache.put(theVersion + theMessageType + theTriggerEvent, rules);
        }
        return rules;
    }

    public List<RuleBinding<MessageRule>> getMessageRuleBindings() {
        return this.myMessageRuleBindings;
    }

    @Override
    public Collection<EncodingRule> getEncodingRules(String theVersion, String theEncoding) {
        Collection<EncodingRule> rules = this.encodingRuleCache.get(theVersion + theEncoding);
        if (rules == null) {
            rules = this.getRules(this.myEncodingRuleBindings, theVersion, theEncoding);
            this.encodingRuleCache.put(theVersion + theEncoding, rules);
        }
        return rules;
    }

    public List<RuleBinding<EncodingRule>> getEncodingRuleBindings() {
        return this.myEncodingRuleBindings;
    }

    private <T extends Rule<?>> Collection<T> getRules(List<RuleBinding<T>> bindings, String version, String scope) {
        ArrayList<T> active = new ArrayList<T>(bindings.size());
        for (RuleBinding<T> binding : bindings) {
            if (!this.applies(binding, version, scope)) continue;
            active.add(binding.getRule());
        }
        return active;
    }

    private boolean applies(RuleBinding<?> binding, String version, String scope) {
        return binding.getActive() && binding.appliesToVersion(version) && binding.appliesToScope(scope);
    }

    protected static <T extends Rule<?>> Map<String, Collection<T>> newRuleCache(int size) {
        RuleCache cache = new RuleCache(size);
        return Collections.synchronizedMap(cache);
    }

    private static class RuleCache<T extends Rule<?>>
    extends LinkedHashMap<String, Collection<T>> {
        private final int size;

        private RuleCache(int size) {
            super(size);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Collection<T>> eldest) {
            return this.size() > this.size;
        }
    }
}

