/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DelegatingMessageVisitor;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageVisitors {
    private MessageVisitors() {
    }

    public static <T extends MessageVisitor> T visit(Visitable visitable, T visitor) throws HL7Exception {
        visitable.accept(visitor, new Location());
        return visitor;
    }

    public static <T extends MessageVisitor> StructuresVisitor<T> visitStructures(T visitor) {
        return new StructuresVisitor<T>(visitor);
    }

    public static <T extends MessageVisitor> PopulatedVisitor<T> visitPopulatedElements(T visitor) {
        return new PopulatedVisitor<T>(visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PopulatedVisitor<T extends MessageVisitor>
    extends DelegatingMessageVisitor<T> {
        PopulatedVisitor(T visitor) {
            super(visitor);
        }

        @Override
        public boolean start(Group group, Location location) throws HL7Exception {
            return !group.isEmpty() && super.start(group, location);
        }

        @Override
        public boolean end(Group group, Location location) throws HL7Exception {
            return !group.isEmpty() && super.end(group, location);
        }

        @Override
        public boolean start(Segment segment, Location location) throws HL7Exception {
            return !segment.isEmpty() && super.start(segment, location);
        }

        @Override
        public boolean end(Segment segment, Location location) throws HL7Exception {
            return !segment.isEmpty() && super.end(segment, location);
        }

        @Override
        public final boolean start(Composite type, Location location) throws HL7Exception {
            return !type.isEmpty() && super.start(type, location);
        }

        @Override
        public boolean end(Composite type, Location location) throws HL7Exception {
            return !type.isEmpty() && super.end(type, location);
        }

        @Override
        public boolean visit(Primitive type, Location location) throws HL7Exception {
            return !type.isEmpty() && super.visit(type, location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StructuresVisitor<T extends MessageVisitor>
    extends DelegatingMessageVisitor<T> {
        StructuresVisitor(T visitor) {
            super(visitor);
        }

        @Override
        public boolean start(Segment segment, Location location) throws HL7Exception {
            super.start(segment, location);
            return false;
        }

        @Override
        public final boolean start(Composite type, Location location) throws HL7Exception {
            return false;
        }

        @Override
        public boolean visit(Primitive type, Location location) throws HL7Exception {
            return false;
        }
    }
}

