/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class MinLLPWriter
implements HL7Writer {
    public static final String CHARSET_KEY = "ca.uhn.hl7v2.llp.charset";
    BufferedWriter myWriter;
    private OutputStream myOutputStream;
    private Charset charset;

    public MinLLPWriter() {
    }

    public MinLLPWriter(OutputStream out) throws IOException {
        this.setOutputStream(out);
    }

    public MinLLPWriter(OutputStream out, Charset theCharset) throws IOException {
        this.charset = theCharset;
        this.setOutputStream(out);
    }

    public synchronized void setOutputStream(OutputStream out) throws IOException {
        this.myOutputStream = out;
        this.myWriter = new BufferedWriter(this.getWriter(out));
    }

    public synchronized void writeMessage(String message) throws LLPException, IOException {
        this.myWriter.write(11);
        this.myWriter.write(message);
        this.myWriter.write("\u001c\r");
        this.myWriter.flush();
    }

    public synchronized void writeMessage(String message, String charset) throws LLPException, IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.myOutputStream, charset));
        writer.write(11);
        writer.write(message);
        writer.write("\u001c\r");
        writer.flush();
    }

    public synchronized void close() throws IOException {
        this.myWriter.close();
    }

    private OutputStreamWriter getWriter(OutputStream theStream) throws IOException {
        if (this.charset != null) {
            return new OutputStreamWriter(theStream, this.charset);
        }
        String charsetString = System.getProperty(CHARSET_KEY, "US-ASCII");
        if (charsetString.equals("default")) {
            return new OutputStreamWriter(theStream);
        }
        return new OutputStreamWriter(theStream, charsetString);
    }
}

