/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.conf.store.CodeStoreRegistry;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.SocketFactory;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import ca.uhn.hl7v2.validation.Validator;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import java.util.concurrent.ExecutorService;

public abstract class HapiContextSupport {
    private HapiContext context;

    public HapiContextSupport(HapiContext context) {
        this.context = context;
    }

    public final HapiContext getHapiContext() {
        return HapiContextSupport.unmodifiableContext(this.context);
    }

    protected void setHapiContext(HapiContext context) {
        this.context = context;
    }

    private static HapiContext unmodifiableContext(HapiContext context) {
        return new UnmodifiableHapiContext(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableHapiContext
    implements HapiContext {
        private HapiContext context;

        public UnmodifiableHapiContext(HapiContext context) {
            this.context = context;
        }

        @Override
        public CodeStoreRegistry getCodeStoreRegistry() {
            return this.context.getCodeStoreRegistry();
        }

        @Override
        public ca.uhn.hl7v2.conf.check.Validator getConformanceValidator() {
            return this.context.getConformanceValidator();
        }

        @Override
        public ConnectionHub getConnectionHub() {
            return this.context.getConnectionHub();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.context.getExecutorService();
        }

        @Override
        public GenericParser getGenericParser() {
            return this.context.getGenericParser();
        }

        @Override
        public LowerLayerProtocol getLowerLayerProtocol() {
            return this.context.getLowerLayerProtocol();
        }

        @Override
        public <R> Validator<R> getMessageValidator() {
            return this.context.getMessageValidator();
        }

        @Override
        public ModelClassFactory getModelClassFactory() {
            return this.context.getModelClassFactory();
        }

        @Override
        public ParserConfiguration getParserConfiguration() {
            return this.context.getParserConfiguration();
        }

        @Override
        public PipeParser getPipeParser() {
            return this.context.getPipeParser();
        }

        @Override
        public ProfileStore getProfileStore() {
            return this.context.getProfileStore();
        }

        @Override
        public SocketFactory getSocketFactory() {
            return this.context.getSocketFactory();
        }

        @Override
        public ValidationContext getValidationContext() {
            return this.context.getValidationContext();
        }

        @Override
        public <R> ValidationExceptionHandlerFactory<R> getValidationExceptionHandlerFactory() {
            return this.context.getValidationExceptionHandlerFactory();
        }

        @Override
        public ValidationRuleBuilder getValidationRuleBuilder() {
            return this.context.getValidationRuleBuilder();
        }

        @Override
        public XMLParser getXMLParser() {
            return this.context.getXMLParser();
        }

        @Override
        public Connection newClient(String host, int port, boolean tls) throws HL7Exception {
            return this.context.newClient(host, port, tls);
        }

        @Override
        public Connection newClient(String host, int outboundPort, int inboundPort, boolean tls) throws HL7Exception {
            return this.context.newClient(host, outboundPort, inboundPort, tls);
        }

        @Override
        public HL7Service newServer(int port, boolean tls) {
            return this.context.newServer(port, tls);
        }

        @Override
        public HL7Service newServer(int inboundPort, int outboundPort, boolean tls) {
            return this.context.newServer(inboundPort, outboundPort, tls);
        }

        @Override
        public void setCodeStoreRegistry(CodeStoreRegistry store) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setExecutorService(ExecutorService executorService) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setLowerLayerProtocol(LowerLayerProtocol llp) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setModelClassFactory(ModelClassFactory modelClassFactory) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setParserConfiguration(ParserConfiguration configuration) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setProfileStore(ProfileStore store) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setSocketFactory(SocketFactory socketFactory) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setValidationContext(String contextClassName) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setValidationContext(ValidationContext context) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public <R> void setValidationExceptionHandlerFactory(ValidationExceptionHandlerFactory<R> factory) {
            this.context.setValidationExceptionHandlerFactory(factory);
        }

        @Override
        public void setValidationRuleBuilder(String builderClassName) {
            throw new UnsupportedOperationException("Read-only instance");
        }

        @Override
        public void setValidationRuleBuilder(ValidationRuleBuilder ruleBuilder) {
            throw new UnsupportedOperationException("Read-only instance");
        }
    }
}

