/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.util.Home;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageIDGenerator {
    private static final Log ourLog = LogFactory.getLog((String)MessageIDGenerator.class.getName());
    private static MessageIDGenerator messageIdGenerator;
    private static final String idFile;
    private long id;
    private FileWriter fileW;

    private MessageIDGenerator() throws IOException {
        block7: {
            try {
                File extFile = new File(idFile);
                if (extFile.createNewFile()) {
                    this.id = 0L;
                    break block7;
                }
                FileReader fileR = new FileReader(idFile);
                char[] charArray = new char[100];
                int e = fileR.read(charArray);
                if (e <= 0) {
                    this.id = 0L;
                } else {
                    String idStr = String.valueOf(charArray);
                    String idStrTrim = idStr.trim();
                    try {
                        this.id = Long.parseLong(idStrTrim);
                    }
                    catch (NumberFormatException nfe) {
                        ourLog.warn((Object)("Failed to parse message ID file value \"" + idStrTrim + "\". Defaulting to 0."));
                    }
                }
                fileR.close();
            }
            catch (FileNotFoundException e) {
                ourLog.error((Object)"Failed to locate ID file", (Throwable)e);
            }
        }
    }

    public static synchronized MessageIDGenerator getInstance() throws IOException {
        if (messageIdGenerator == null) {
            messageIdGenerator = new MessageIDGenerator();
        }
        return messageIdGenerator;
    }

    public synchronized String getNewID() throws IOException {
        ++this.id;
        this.fileW = new FileWriter(idFile, false);
        String idStr = String.valueOf(this.id);
        this.fileW.write(idStr);
        this.fileW.flush();
        this.fileW.close();
        return String.valueOf(this.id);
    }

    static {
        idFile = Home.getHomeDirectory().getAbsolutePath() + "/id_file";
    }
}

