/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.util.CodeMapper;
import ca.uhn.hl7v2.util.Home;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FileCodeMapper
extends CodeMapper {
    private static final HapiLog log = HapiLogFactory.getHapiLog(FileCodeMapper.class);
    private boolean throwIfNoMatch = false;
    File baseDir = new File(Home.getHomeDirectory().getAbsolutePath() + "/codemap");
    private HashMap interfaceToLocal;
    private HashMap localToInterface;

    public FileCodeMapper() throws HL7Exception {
        this.refreshCache();
    }

    public void refreshCache() throws HL7Exception {
        this.localToInterface = new HashMap(10);
        this.interfaceToLocal = new HashMap(10);
        log.info("Refreshing cache");
        try {
            File[] interfaceDirs = this.baseDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    boolean acc = false;
                    if (pathname.isDirectory()) {
                        acc = true;
                    }
                    return acc;
                }
            });
            for (int i = 0; i < interfaceDirs.length; ++i) {
                log.info("Checking directory " + interfaceDirs[i].getName() + " for interface code maps.");
                File[] mapFiles = interfaceDirs[i].listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        boolean acc = false;
                        if (name.toUpperCase().startsWith("HL7") && (name.substring(name.lastIndexOf(46)).equals(".li") || name.substring(name.lastIndexOf(46)).equals(".il"))) {
                            acc = true;
                        }
                        return acc;
                    }
                });
                HashMap li = new HashMap(50);
                HashMap il = new HashMap(50);
                for (int j = 0; j < mapFiles.length; ++j) {
                    log.info("Reading map entries from file " + mapFiles[j]);
                    String fName = mapFiles[j].getName();
                    String tableName = fName.substring(0, fName.lastIndexOf(46));
                    String mapDirection = fName.substring(fName.lastIndexOf(46) + 1);
                    BufferedReader in = new BufferedReader(new FileReader(mapFiles[j]));
                    HashMap<String, String> codeMap = new HashMap<String, String>(25);
                    while (in.ready()) {
                        String line = in.readLine();
                        if (line.startsWith("//")) continue;
                        StringTokenizer tok = new StringTokenizer(line, "\t", false);
                        String from = null;
                        String to = null;
                        if (tok.hasMoreTokens()) {
                            from = tok.nextToken();
                        }
                        if (tok.hasMoreTokens()) {
                            to = tok.nextToken();
                        }
                        if (from == null || to == null) continue;
                        codeMap.put(from, to);
                    }
                    if (mapDirection.equals("il")) {
                        il.put(tableName.toUpperCase(), codeMap);
                        log.debug("Adding " + codeMap.size() + " codes to interface -> local map for " + tableName + " in " + interfaceDirs[i].getName() + " interface");
                        continue;
                    }
                    li.put(tableName.toUpperCase(), codeMap);
                    log.debug("Adding " + codeMap.size() + " codes to local -> interface map for " + tableName + " in " + interfaceDirs[i].getName() + " interface");
                }
                this.interfaceToLocal.put(interfaceDirs[i].getName(), il);
                this.localToInterface.put(interfaceDirs[i].getName(), li);
            }
        }
        catch (IOException e) {
            throw new HL7Exception("Can't read interface code maps from disk", 207, e);
        }
    }

    public String getLocalCode(String interfaceName, int hl7Table, String interfaceCode) throws HL7Exception {
        String localCode;
        block2: {
            localCode = null;
            try {
                HashMap interfaceMap = (HashMap)this.interfaceToLocal.get(interfaceName);
                localCode = this.getCode(interfaceMap, hl7Table, interfaceCode);
            }
            catch (NullPointerException npe) {
                if (!this.throwIfNoMatch) break block2;
                throw new HL7Exception("No local mapping for the interface code " + interfaceCode + " for HL7 table " + hl7Table + " for the interface '" + interfaceName + "'", 103);
            }
        }
        return localCode;
    }

    private String getCode(HashMap interfaceMap, int hl7Table, String code) {
        String ret = null;
        StringBuffer tableName = new StringBuffer();
        tableName.append("HL7");
        if (hl7Table < 1000) {
            tableName.append("0");
        }
        if (hl7Table < 100) {
            tableName.append("0");
        }
        if (hl7Table < 10) {
            tableName.append("0");
        }
        tableName.append(hl7Table);
        HashMap tableMap = (HashMap)interfaceMap.get(tableName.toString());
        ret = tableMap.get(code).toString();
        return ret;
    }

    public String getInterfaceCode(String interfaceName, int hl7Table, String localCode) throws HL7Exception {
        String interfaceCode;
        block2: {
            interfaceCode = null;
            try {
                HashMap interfaceMap = (HashMap)this.localToInterface.get(interfaceName);
                interfaceCode = this.getCode(interfaceMap, hl7Table, localCode);
            }
            catch (NullPointerException npe) {
                if (!this.throwIfNoMatch) break block2;
                throw new HL7Exception("No interface mapping for the local code " + localCode + " for HL7 table " + hl7Table + " for the interface '" + interfaceName + "'", 103);
            }
        }
        return interfaceCode;
    }

    public void throwExceptionIfNoMatch(boolean throwException) {
        this.throwIfNoMatch = throwException;
    }

    public static void main(String[] args) {
        try {
            CodeMapper.getInstance().throwExceptionIfNoMatch(true);
            System.out.println("Local code for M is " + CodeMapper.getLocal("test", 1, "M"));
            System.out.println("Interface code for female is " + CodeMapper.getInt("test", 1, "female"));
        }
        catch (HL7Exception e) {
            e.printStackTrace();
        }
    }
}

