/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.impl.SocketStreamSource;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class ServerSocketStreamSource
extends SocketStreamSource {
    private ServerSocket myServerSocket;
    private String myExpectedAddress;
    private Socket mySocket;
    private Acceptor myAcceptor;
    private boolean myProceedWithConnect;

    public ServerSocketStreamSource(ServerSocket theServerSocket, String theExpectedAddress) throws TransportException {
        this.myServerSocket = theServerSocket;
        this.myExpectedAddress = theExpectedAddress;
    }

    public Socket getSocket() {
        return this.mySocket;
    }

    public void connect() throws TransportException {
        Acceptor a = new Acceptor(this.myServerSocket, this.myExpectedAddress);
        this.mySocket = a.waitForSocket();
    }

    private static class Acceptor {
        private static final HapiLog log = HapiLogFactory.getHapiLog(Acceptor.class);
        private Socket mySocket;

        public Acceptor(final ServerSocket theServer, final String theAddress) {
            final Acceptor a = this;
            if (theAddress != null) {
                log.info("Server socket is about to try to accept a connection from " + theAddress);
            } else {
                log.info("Server socket is about to try to accept a connection from any addess");
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        block12: {
                            try {
                                if (theServer.isClosed()) break block12;
                                Socket s = theServer.accept();
                                String address = s.getInetAddress().getHostAddress();
                                if (theAddress == null || address.equals(theAddress)) {
                                    a.setSocket(s);
                                    Acceptor acceptor = a;
                                    synchronized (acceptor) {
                                        a.notifyAll();
                                        break block12;
                                    }
                                }
                                log.info("Ignoring connection from " + address + ": expecting " + theAddress);
                            }
                            catch (SocketTimeoutException e) {
                                log.debug("Socket timed out without receiving a connection");
                            }
                            catch (IOException e) {
                                log.error("Error accepting remote connection", e);
                            }
                        }
                        if (a.getSocket() != null) {
                            log.info("Accepted connection from address: " + a.getSocket().getInetAddress());
                            return;
                        }
                        if (theServer.isClosed()) {
                            log.warn("Server socket closed, aborting");
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            Thread thd = new Thread(r);
            thd.start();
        }

        public void setSocket(Socket theSocket) {
            this.mySocket = theSocket;
        }

        public Socket getSocket() {
            return this.mySocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket waitForSocket() {
            while (this.getSocket() == null) {
                try {
                    Acceptor acceptor = this;
                    synchronized (acceptor) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return this.getSocket();
        }
    }
}

