/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.GroupPointer;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.Pointer;
import ca.uhn.hl7v2.parser.SegmentPointer;

public class MessagePointer {
    private PipeParser parser;
    private EncodingCharacters encodingChars;
    private Pointer[] children;
    private Message message;
    private int childAtWhichToStart = 0;

    public MessagePointer(PipeParser parser, Message message, EncodingCharacters encodingChars) throws HL7Exception {
        this.parser = parser;
        this.message = message;
        this.encodingChars = encodingChars;
        this.makeChildren();
    }

    public int setSegment(String segment) throws HL7Exception {
        int status = this.tryToFillChildren(segment);
        return status;
    }

    private int tryToFillChildren(String segment) throws HL7Exception {
        int status = 0;
        int c = 0;
        while (status != 2 && c < this.children.length) {
            boolean correctOrder = c >= this.childAtWhichToStart;
            status = this.children[c++].setSegment(segment, correctOrder);
        }
        if (status == 2) {
            this.childAtWhichToStart = c - 1;
        }
        return status;
    }

    private void makeChildren() throws HL7Exception {
        String[] childNames = this.message.getNames();
        this.children = new Pointer[childNames.length];
        for (int i = 0; i < childNames.length; ++i) {
            Class childClass = this.message.getClass(childNames[i]);
            Pointer p = Group.class.isAssignableFrom(childClass) ? new GroupPointer(this.parser, this.message, i, this.encodingChars) : new SegmentPointer(this.parser, this.message, i, this.encodingChars);
            this.children[i] = p;
        }
    }
}

