/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.MessageReceipt;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;

public class Receiver
implements Runnable {
    private static final HapiLog log = HapiLogFactory.getHapiLog(Receiver.class);
    private Connection conn;
    private HL7Reader in;
    private boolean running;

    public Receiver(Connection c, HL7Reader in) {
        this.conn = c;
        this.in = in;
    }

    public void run() {
        while (this.running) {
            Thread.yield();
            try {
                String message = this.in.getMessage();
                if (message == null) {
                    log.info("Closing connection (no more messages available).");
                    this.conn.close();
                    continue;
                }
                this.processMessage(message);
            }
            catch (IOException e) {
                this.conn.close();
                log.error("IOException: closing Connection, will no longer read messages with this Receiver. ", e);
            }
            catch (Exception e) {
                log.error("Error while closing connection: ", e);
            }
        }
    }

    protected void processMessage(String message) {
        String ackID = this.conn.getParser().getAckID(message);
        if (ackID == null) {
            Grunt g = new Grunt(this.conn, message);
            g.start();
        } else {
            MessageReceipt mr = this.conn.findRecipient(ackID);
            if (mr == null) {
                log.info("Unexpected Message Received: " + message);
            } else {
                mr.setMessage(message);
            }
        }
    }

    public void start() {
        this.running = true;
        Thread thd = new Thread(this);
        thd.start();
    }

    public void stop() {
        this.running = false;
    }

    private class Grunt
    extends Thread {
        private Connection conn;
        private String m;

        public Grunt(Connection conn, String message) {
            this.conn = conn;
            this.m = message;
        }

        public void run() {
            try {
                String response = this.conn.getResponder().processMessage(this.m);
                this.conn.getAckWriter().writeMessage(response);
            }
            catch (Exception e) {
                log.error("Error while processing message: ", e);
            }
        }
    }
}

